/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.metadata;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.drive.metadata.zzc;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class CustomPropertyKey
extends zza {
    public static final Parcelable.Creator<CustomPropertyKey> CREATOR = new zzc();
    public static final int PUBLIC = 0;
    public static final int PRIVATE = 1;
    private String zzBN;
    private int mVisibility;
    private static final Pattern zzaPF = Pattern.compile("[\\w.!@$%^&*()/-]+");

    public CustomPropertyKey(String string, int n) {
        zzbo.zzb((Object)string, (Object)"key");
        zzbo.zzb((boolean)zzaPF.matcher(string).matches(), (Object)"key name characters must be alphanumeric or one of .!@$%^&*()-_/");
        zzbo.zzb((n == 0 || n == 1 ? 1 : 0) != 0, (Object)"visibility must be either PUBLIC or PRIVATE");
        this.zzBN = string;
        this.mVisibility = n;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CustomPropertyKey customPropertyKey = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (String)customPropertyKey.zzBN, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)3, (int)customPropertyKey.mVisibility);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public String getKey() {
        return this.zzBN;
    }

    public int getVisibility() {
        return this.mVisibility;
    }

    public int hashCode() {
        String string = this.zzBN;
        int n = this.mVisibility;
        return new StringBuilder(11 + String.valueOf(string).length()).append(string).append(n).toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof CustomPropertyKey)) {
            return false;
        }
        CustomPropertyKey customPropertyKey = (CustomPropertyKey)((Object)object);
        return customPropertyKey.getKey().equals(this.zzBN) && customPropertyKey.getVisibility() == this.mVisibility;
    }

    public String toString() {
        String string = this.zzBN;
        int n = this.mVisibility;
        return new StringBuilder(31 + String.valueOf(string).length()).append("CustomPropertyKey(").append(string).append(",").append(n).append(")").toString();
    }

    public JSONObject toJson() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("key", (Object)this.getKey());
        jSONObject.put("visibility", this.getVisibility());
        return jSONObject;
    }

    public static CustomPropertyKey fromJson(JSONObject jSONObject) throws JSONException {
        return new CustomPropertyKey(jSONObject.getString("key"), jSONObject.getInt("visibility"));
    }
}

