/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.zzj;
import com.google.android.gms.internal.ado;
import com.google.android.gms.internal.adp;
import com.google.android.gms.internal.zzbms;
import com.google.android.gms.internal.zzbmx;
import com.google.android.gms.internal.zzbng;
import com.google.android.gms.internal.zzbnn;
import com.google.android.gms.internal.zzbra;
import com.google.android.gms.internal.zzbrb;

public class DriveId
extends zza
implements ReflectedParcelable {
    public static final int RESOURCE_TYPE_UNKNOWN = -1;
    public static final int RESOURCE_TYPE_FILE = 0;
    public static final int RESOURCE_TYPE_FOLDER = 1;
    public static final Parcelable.Creator<DriveId> CREATOR = new zzj();
    private String zzaMh;
    private long zzaMi;
    private long zzaLQ;
    private int zzaMj;
    private volatile String zzaLS = null;
    private volatile String zzaMk = null;

    public static DriveId zzcO(String string) {
        zzbo.zzu((Object)string);
        return new DriveId(string, -1L, -1L, -1);
    }

    public String getResourceId() {
        return this.zzaMh;
    }

    public int getResourceType() {
        return this.zzaMj;
    }

    public DriveFile asDriveFile() {
        if (this.zzaMj == 1) {
            throw new IllegalStateException("This DriveId corresponds to a folder. Call asDriveFolder instead.");
        }
        return new zzbms(this);
    }

    public DriveFolder asDriveFolder() {
        if (this.zzaMj == 0) {
            throw new IllegalStateException("This DriveId corresponds to a file. Call asDriveFile instead.");
        }
        return new zzbmx(this);
    }

    public DriveResource asDriveResource() {
        if (this.zzaMj == 1) {
            return this.asDriveFolder();
        }
        if (this.zzaMj == 0) {
            return this.asDriveFile();
        }
        return new zzbnn(this);
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DriveId driveId = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (String)driveId.zzaMh, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (long)driveId.zzaMi);
        zzd.zza((Parcel)parcel2, (int)4, (long)driveId.zzaLQ);
        zzd.zzc((Parcel)parcel2, (int)5, (int)driveId.zzaMj);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public DriveId(String string, long l, long l2, int n) {
        this.zzaMh = string;
        zzbo.zzaf((!"".equals(string) ? 1 : 0) != 0);
        zzbo.zzaf((string != null || l != -1L ? 1 : 0) != 0);
        this.zzaMi = l;
        this.zzaLQ = l2;
        this.zzaMj = n;
    }

    public int hashCode() {
        if (this.zzaMi == -1L) {
            return this.zzaMh.hashCode();
        }
        String string = String.valueOf(String.valueOf(this.zzaLQ));
        String string2 = String.valueOf(String.valueOf(this.zzaMi));
        return (string2.length() != 0 ? string.concat(string2) : new String(string)).hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DriveId)) {
            return false;
        }
        DriveId driveId = (DriveId)((Object)object);
        if (driveId.zzaLQ != this.zzaLQ) {
            return false;
        }
        if (driveId.zzaMi == -1L && this.zzaMi == -1L) {
            return driveId.zzaMh.equals(this.zzaMh);
        }
        if (this.zzaMh == null || driveId.zzaMh == null) {
            return driveId.zzaMi == this.zzaMi;
        }
        if (driveId.zzaMi == this.zzaMi) {
            if (driveId.zzaMh.equals(this.zzaMh)) {
                return true;
            }
            zzbng.zzy("DriveId", "Unexpected unequal resourceId for same DriveId object.");
        }
        return false;
    }

    public final String encodeToString() {
        if (this.zzaLS == null) {
            DriveId driveId = this;
            zzbra zzbra2 = new zzbra();
            new zzbra().versionCode = 1;
            zzbra2.zzaPy = driveId.zzaMh == null ? "" : driveId.zzaMh;
            zzbra2.zzaPz = driveId.zzaMi;
            zzbra2.zzaPw = driveId.zzaLQ;
            zzbra2.zzaPA = driveId.zzaMj;
            String string = Base64.encodeToString((byte[])adp.zzc((adp)zzbra2), (int)10);
            String string2 = String.valueOf("DriveId:");
            String string3 = String.valueOf(string);
            this.zzaLS = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        }
        return this.zzaLS;
    }

    public final String toInvariantString() {
        if (this.zzaMk == null) {
            DriveId driveId = this;
            zzbrb zzbrb2 = new zzbrb();
            new zzbrb().zzaPz = driveId.zzaMi;
            zzbrb2.zzaPw = driveId.zzaLQ;
            byte[] byArray = adp.zzc((adp)zzbrb2);
            this.zzaMk = Base64.encodeToString((byte[])byArray, (int)10);
        }
        return this.zzaMk;
    }

    public String toString() {
        return this.encodeToString();
    }

    public static DriveId decodeFromString(String string) {
        String string2 = String.valueOf(string);
        zzbo.zzb((boolean)string.startsWith("DriveId:"), (Object)(string2.length() != 0 ? "Invalid DriveId: ".concat(string2) : new String("Invalid DriveId: ")));
        return DriveId.zzi(Base64.decode((String)string.substring(8), (int)10));
    }

    private static DriveId zzi(byte[] byArray) {
        zzbra zzbra2;
        try {
            byte[] byArray2 = byArray;
            zzbra2 = (zzbra)adp.zza((adp)new zzbra(), (byte[])byArray2);
        }
        catch (ado ado2) {
            throw new IllegalArgumentException();
        }
        String string = "".equals(zzbra2.zzaPy) ? null : zzbra2.zzaPy;
        return new DriveId(string, zzbra2.zzaPz, zzbra2.zzaPw, zzbra2.zzaPA);
    }
}

