/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.text.TextUtils;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.internal.zzbmh;
import java.util.Arrays;

public class ExecutionOptions {
    public static final int MAX_TRACKING_TAG_STRING_LENGTH = 65536;
    public static final int CONFLICT_STRATEGY_OVERWRITE_REMOTE = 0;
    public static final int CONFLICT_STRATEGY_KEEP_REMOTE = 1;
    private final String zzaMr;
    private final boolean zzaMs;
    private final int zzaMt;

    public ExecutionOptions(String string, boolean bl, int n) {
        this.zzaMr = string;
        this.zzaMs = bl;
        this.zzaMt = n;
    }

    public final String zzsP() {
        return this.zzaMr;
    }

    public final boolean zzsQ() {
        return this.zzaMs;
    }

    public final int zzsR() {
        return this.zzaMt;
    }

    public final void zze(GoogleApiClient googleApiClient) {
        zzbmh zzbmh2 = (zzbmh)googleApiClient.zza(Drive.zzajR);
        if (this.zzaMs && !zzbmh2.zzti()) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to be notified on completion");
        }
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        if (object == this) {
            return true;
        }
        ExecutionOptions executionOptions = (ExecutionOptions)object;
        return zzbe.equal((Object)this.zzaMr, (Object)executionOptions.zzaMr) && this.zzaMt == executionOptions.zzaMt && this.zzaMs == executionOptions.zzaMs;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzaMr, this.zzaMt, this.zzaMs});
    }

    public static class Builder {
        protected String zzaMr;
        protected boolean zzaMs;
        protected int zzaMt = 0;

        public Builder setTrackingTag(String string) {
            String string2 = string;
            if (!(!TextUtils.isEmpty((CharSequence)string2) && string2.length() <= 65536)) {
                throw new IllegalArgumentException(String.format("trackingTag must not be null nor empty, and the length must be <= the maximum length (%s)", 65536));
            }
            this.zzaMr = string;
            return this;
        }

        public Builder setNotifyOnCompletion(boolean bl) {
            this.zzaMs = bl;
            return this;
        }

        public Builder setConflictStrategy(int n) {
            boolean bl;
            switch (n) {
                case 0: 
                case 1: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (!bl) {
                throw new IllegalArgumentException(new StringBuilder(53).append("Unrecognized value for conflict strategy: ").append(n).toString());
            }
            this.zzaMt = n;
            return this;
        }

        protected final void zzsS() {
            if (this.zzaMt == 1 && !this.zzaMs) {
                throw new IllegalStateException("Cannot use CONFLICT_STRATEGY_KEEP_REMOTE without requesting completion notifications");
            }
        }

        public ExecutionOptions build() {
            this.zzsS();
            return new ExecutionOptions(this.zzaMr, this.zzaMs, this.zzaMt);
        }
    }
}

