/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.util.zzv;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.zzd;
import com.google.android.gms.drive.events.zzj;
import com.google.android.gms.internal.zzbhg;
import com.google.android.gms.internal.zzbib;
import com.google.android.gms.internal.zzbit;
import com.google.android.gms.internal.zzbix;
import com.google.android.gms.internal.zzbiy;
import com.google.android.gms.internal.zzbiz;
import com.google.android.gms.internal.zzbkr;
import com.google.android.gms.internal.zzblb;
import com.google.android.gms.internal.zzblc;
import com.google.android.gms.internal.zzbmz;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class zzbiw
extends zzaa<zzblb> {
    private final String zzdxd;
    private final Bundle zzggt;
    private final boolean zzggu;
    private volatile DriveId zzggv;
    private volatile DriveId zzggw;
    private volatile boolean zzggx = false;
    private GoogleApiClient.ConnectionCallbacks zzggy;
    private Map<DriveId, Map<ChangeListener, zzbkr>> zzggz = new HashMap<DriveId, Map<ChangeListener, zzbkr>>();
    private Map<zzd, zzbkr> zzgha = new HashMap<zzd, zzbkr>();
    private Map<DriveId, Map<Object, zzbkr>> zzghb = new HashMap<DriveId, Map<Object, zzbkr>>();
    private Map<DriveId, Map<Object, zzbkr>> zzghc = new HashMap<DriveId, Map<Object, zzbkr>>();

    public zzbiw(Context context, Looper looper, zzq zzq2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, Bundle bundle) {
        super(context, looper, 11, zzq2, connectionCallbacks, onConnectionFailedListener);
        this.zzdxd = zzq2.zzaju();
        this.zzggy = connectionCallbacks;
        this.zzggt = bundle;
        Intent intent = new Intent("com.google.android.gms.drive.events.HANDLE_EVENT");
        intent.setPackage(context.getPackageName());
        List list = context.getPackageManager().queryIntentServices(intent, 0);
        switch (list.size()) {
            case 0: {
                this.zzggu = false;
                return;
            }
            case 1: {
                ServiceInfo serviceInfo = ((ResolveInfo)list.get((int)0)).serviceInfo;
                if (!serviceInfo.exported) {
                    String string = serviceInfo.name;
                    throw new IllegalStateException(new StringBuilder(60 + String.valueOf(string).length()).append("Drive event service ").append(string).append(" must be exported in AndroidManifest.xml").toString());
                }
                this.zzggu = true;
                return;
            }
        }
        String string = intent.getAction();
        throw new IllegalStateException(new StringBuilder(72 + String.valueOf(string).length()).append("AndroidManifest.xml can only define one service that handles the ").append(string).append(" action").toString());
    }

    public final boolean zzaaa() {
        return !this.getContext().getPackageName().equals(this.zzdxd) || !zzv.zzf((Context)this.getContext(), (int)Process.myUid());
    }

    public final boolean zzajk() {
        return true;
    }

    protected final String zzhd() {
        return "com.google.android.gms.drive.internal.IDriveService";
    }

    protected final Bundle zzzs() {
        String string = this.getContext().getPackageName();
        zzbp.zzu((Object)string);
        zzbp.zzbg((!this.zzakd().zzajs().isEmpty() ? 1 : 0) != 0);
        Bundle bundle = new Bundle();
        if (!string.equals(this.zzdxd)) {
            bundle.putString("proxy_package_name", this.zzdxd);
        }
        bundle.putAll(this.zzggt);
        return bundle;
    }

    protected final String zzhc() {
        return "com.google.android.gms.drive.ApiService.START";
    }

    public final DriveId zzanj() {
        return this.zzggv;
    }

    public final DriveId zzank() {
        return this.zzggw;
    }

    public final boolean zzanl() {
        return this.zzggx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disconnect() {
        if (this.isConnected()) {
            try {
                ((zzblb)this.zzajj()).zza(new zzbib());
            }
            catch (RemoteException remoteException) {}
        }
        super.disconnect();
        Map<Object, Object> map = this.zzggz;
        synchronized (map) {
            this.zzggz.clear();
        }
        map = this.zzgha;
        synchronized (map) {
            this.zzgha.clear();
        }
        map = this.zzghb;
        synchronized (map) {
            this.zzghb.clear();
        }
        map = this.zzghc;
        synchronized (map) {
            this.zzghc.clear();
            return;
        }
    }

    protected final void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (bundle != null) {
            bundle.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.zzggv = (DriveId)bundle.getParcelable("com.google.android.gms.drive.root_id");
            this.zzggw = (DriveId)bundle.getParcelable("com.google.android.gms.drive.appdata_id");
            this.zzggx = true;
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public final boolean zzanm() {
        return this.zzggu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        zzbp.zzbh((boolean)zzj.zza(1, driveId));
        zzbp.zzb((Object)changeListener, (Object)"listener");
        zzbp.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        Map<DriveId, Map<ChangeListener, zzbkr>> map = this.zzggz;
        synchronized (map) {
            zzbkr zzbkr2;
            Map<ChangeListener, zzbkr> map2 = this.zzggz.get((Object)driveId);
            if (map2 == null) {
                map2 = new HashMap<ChangeListener, zzbkr>();
                this.zzggz.put(driveId, map2);
            }
            if ((zzbkr2 = map2.get(changeListener)) == null) {
                zzbkr2 = new zzbkr(this.getLooper(), this.getContext(), 1, changeListener);
                map2.put(changeListener, zzbkr2);
            } else if (zzbkr2.zzcr(1)) {
                return new zzbit(googleApiClient, Status.zzfhp);
            }
            zzbkr2.zzcq(1);
            zzbkr zzbkr3 = zzbkr2;
            zzbhg zzbhg2 = new zzbhg(1, driveId);
            GoogleApiClient googleApiClient2 = googleApiClient;
            zzbiw zzbiw2 = this;
            return googleApiClient2.zze((zzm)new zzbix(zzbiw2, googleApiClient2, zzbhg2, zzbkr3));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PendingResult<Status> zzb(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        zzbp.zzbh((boolean)zzj.zza(1, driveId));
        zzbp.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        zzbp.zzb((Object)changeListener, (Object)"listener");
        Map<DriveId, Map<ChangeListener, zzbkr>> map = this.zzggz;
        synchronized (map) {
            Map<ChangeListener, zzbkr> map2 = this.zzggz.get((Object)driveId);
            if (map2 == null) {
                return new zzbit(googleApiClient, Status.zzfhp);
            }
            zzbkr zzbkr2 = map2.remove(changeListener);
            if (zzbkr2 == null) {
                return new zzbit(googleApiClient, Status.zzfhp);
            }
            if (map2.isEmpty()) {
                this.zzggz.remove((Object)driveId);
            }
            zzbkr zzbkr3 = zzbkr2;
            zzbmz zzbmz2 = new zzbmz(driveId, 1);
            GoogleApiClient googleApiClient2 = googleApiClient;
            zzbiw zzbiw2 = this;
            return googleApiClient2.zze((zzm)new zzbiy(zzbiw2, googleApiClient2, zzbmz2, zzbkr3));
        }
    }

    final PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId) {
        zzbhg zzbhg2 = new zzbhg(1, driveId);
        GoogleApiClient googleApiClient2 = googleApiClient;
        zzbiw zzbiw2 = this;
        zzbp.zzbh((boolean)zzj.zza(zzbhg2.zzfxs, zzbhg2.zzgcx));
        zzbp.zza((boolean)zzbiw2.isConnected(), (Object)"Client must be connected");
        if (!zzbiw2.zzggu) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to add event subscriptions");
        }
        return googleApiClient2.zze((zzm)new zzbiz(zzbiw2, googleApiClient2, zzbhg2));
    }

    protected final /* synthetic */ IInterface zze(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.drive.internal.IDriveService");
        if (iInterface instanceof zzblb) {
            return (zzblb)iInterface;
        }
        return new zzblc(iBinder2);
    }
}

