/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.ParcelFileDescriptor;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.util.zzm;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.zzc;
import com.google.android.gms.drive.zzp;
import com.google.android.gms.drive.zzr;
import com.google.android.gms.internal.zzbjd;
import com.google.android.gms.internal.zzbje;
import com.google.android.gms.internal.zzbjf;
import com.google.android.gms.internal.zzbjg;
import java.io.InputStream;
import java.io.OutputStream;

public final class zzbjc
implements DriveContents {
    private final zzc zzghj;
    private boolean mClosed = false;
    private boolean zzghk = false;
    private boolean zzghl = false;

    public zzbjc(zzc zzc2) {
        this.zzghj = (zzc)((Object)zzbp.zzu((Object)((Object)zzc2)));
    }

    @Override
    public final DriveId getDriveId() {
        return this.zzghj.getDriveId();
    }

    @Override
    public final int getMode() {
        return this.zzghj.getMode();
    }

    @Override
    public final ParcelFileDescriptor getParcelFileDescriptor() {
        if (this.mClosed) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        return this.zzghj.getParcelFileDescriptor();
    }

    @Override
    public final InputStream getInputStream() {
        if (this.mClosed) {
            throw new IllegalStateException("Contents have been closed, cannot access the input stream.");
        }
        if (this.zzghj.getMode() != 0x10000000) {
            throw new IllegalStateException("getInputStream() can only be used with contents opened with MODE_READ_ONLY.");
        }
        if (this.zzghk) {
            throw new IllegalStateException("getInputStream() can only be called once per Contents instance.");
        }
        this.zzghk = true;
        return this.zzghj.getInputStream();
    }

    @Override
    public final OutputStream getOutputStream() {
        if (this.mClosed) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        if (this.zzghj.getMode() != 0x20000000) {
            throw new IllegalStateException("getOutputStream() can only be used with contents opened with MODE_WRITE_ONLY.");
        }
        if (this.zzghl) {
            throw new IllegalStateException("getOutputStream() can only be called once per Contents instance.");
        }
        this.zzghl = true;
        return this.zzghj.getOutputStream();
    }

    @Override
    public final PendingResult<DriveApi.DriveContentsResult> reopenForWrite(GoogleApiClient googleApiClient) {
        if (this.mClosed) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.zzghj.getMode() != 0x10000000) {
            throw new IllegalStateException("reopenForWrite can only be used with DriveContents opened with MODE_READ_ONLY.");
        }
        this.zzamr();
        return googleApiClient.zzd((com.google.android.gms.common.api.internal.zzm)new zzbjd(this, googleApiClient));
    }

    @Override
    public final PendingResult<Status> commit(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet) {
        return this.zza(googleApiClient, metadataChangeSet, null);
    }

    @Override
    public final PendingResult<Status> commit(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, ExecutionOptions executionOptions) {
        zzp zzp2;
        if (executionOptions == null) {
            zzp2 = null;
        } else {
            ExecutionOptions executionOptions2 = executionOptions;
            zzr zzr2 = new zzr();
            if (executionOptions2 != null) {
                ((ExecutionOptions.Builder)zzr2).setConflictStrategy(executionOptions2.zzamv());
                ((ExecutionOptions.Builder)zzr2).setNotifyOnCompletion(executionOptions2.zzamu());
                String string = executionOptions2.zzamt();
                if (string != null) {
                    ((ExecutionOptions.Builder)zzr2).setTrackingTag(string);
                }
            }
            zzp2 = (zzp)((ExecutionOptions.Builder)zzr2).build();
        }
        return this.zza(googleApiClient, metadataChangeSet, zzp2);
    }

    private final PendingResult<Status> zza(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, zzp zzp2) {
        boolean bl;
        if (zzp2 == null) {
            zzp2 = (zzp)((ExecutionOptions.Builder)new zzr()).build();
        }
        if (this.zzghj.getMode() == 0x10000000) {
            throw new IllegalStateException("Cannot commit contents opened with MODE_READ_ONLY");
        }
        switch (zzp2.zzamv()) {
            case 1: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl && !this.zzghj.zzamp()) {
            throw new IllegalStateException("DriveContents must be valid for conflict detection.");
        }
        zzp2.zze(googleApiClient);
        if (this.mClosed) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.getDriveId() == null) {
            throw new IllegalStateException("Only DriveContents obtained through DriveFile.open can be committed.");
        }
        MetadataChangeSet metadataChangeSet2 = metadataChangeSet != null ? metadataChangeSet : MetadataChangeSet.zzgeb;
        zzp zzp3 = zzp2;
        this.zzamr();
        return googleApiClient.zze((com.google.android.gms.common.api.internal.zzm)new zzbje(this, googleApiClient, metadataChangeSet2, zzp3));
    }

    @Override
    public final void discard(GoogleApiClient googleApiClient) {
        if (this.mClosed) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        this.zzamr();
        ((zzbjg)googleApiClient.zze((com.google.android.gms.common.api.internal.zzm)new zzbjg(this, googleApiClient))).setResultCallback(new zzbjf(this));
    }

    @Override
    public final zzc zzamq() {
        return this.zzghj;
    }

    @Override
    public final void zzamr() {
        zzm.zza((ParcelFileDescriptor)this.zzghj.getParcelFileDescriptor());
        this.mClosed = true;
    }

    @Override
    public final boolean zzams() {
        return this.mClosed;
    }

    static /* synthetic */ zzc zza(zzbjc zzbjc2) {
        return zzbjc2.zzghj;
    }
}

