/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzal;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.zzl;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import com.google.android.gms.internal.zzbnd;
import com.google.android.gms.internal.zzbni;
import com.google.android.gms.internal.zzbpj;
import com.google.android.gms.internal.zzbtf;
import com.google.android.gms.internal.zzbtg;
import com.google.android.gms.internal.zzfjr;
import com.google.android.gms.internal.zzfjs;

public class DriveId
extends zzbfm
implements ReflectedParcelable {
    private static final zzal zzgjj = new zzal("DriveId", "");
    public static final int RESOURCE_TYPE_UNKNOWN = -1;
    public static final int RESOURCE_TYPE_FILE = 0;
    public static final int RESOURCE_TYPE_FOLDER = 1;
    public static final Parcelable.Creator<DriveId> CREATOR = new zzl();
    private String zzgjk;
    private long zzgjl;
    private long zzgin;
    private int zzgjm;
    private volatile String zzgip = null;
    private volatile String zzgjn = null;

    public static DriveId zzgv(String string) {
        zzbq.checkNotNull((Object)string);
        return new DriveId(string, -1L, -1L, -1);
    }

    public String getResourceId() {
        return this.zzgjk;
    }

    public int getResourceType() {
        return this.zzgjm;
    }

    public DriveFile asDriveFile() {
        if (this.zzgjm == 1) {
            throw new IllegalStateException("This DriveId corresponds to a folder. Call asDriveFolder instead.");
        }
        return new zzbnd(this);
    }

    public DriveFolder asDriveFolder() {
        if (this.zzgjm == 0) {
            throw new IllegalStateException("This DriveId corresponds to a file. Call asDriveFile instead.");
        }
        return new zzbni(this);
    }

    public DriveResource asDriveResource() {
        if (this.zzgjm == 1) {
            return this.asDriveFolder();
        }
        if (this.zzgjm == 0) {
            return this.asDriveFile();
        }
        return new zzbpj(this);
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DriveId driveId = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)2, (String)driveId.zzgjk, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)3, (long)driveId.zzgjl);
        zzbfp.zza((Parcel)parcel2, (int)4, (long)driveId.zzgin);
        zzbfp.zzc((Parcel)parcel2, (int)5, (int)driveId.zzgjm);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public DriveId(String string, long l, long l2, int n) {
        this.zzgjk = string;
        zzbq.checkArgument((!"".equals(string) ? 1 : 0) != 0);
        zzbq.checkArgument((string != null || l != -1L ? 1 : 0) != 0);
        this.zzgjl = l;
        this.zzgin = l2;
        this.zzgjm = n;
    }

    public int hashCode() {
        if (this.zzgjl == -1L) {
            return this.zzgjk.hashCode();
        }
        String string = String.valueOf(String.valueOf(this.zzgin));
        String string2 = String.valueOf(String.valueOf(this.zzgjl));
        return (string2.length() != 0 ? string.concat(string2) : new String(string)).hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != DriveId.class) {
            return false;
        }
        DriveId driveId = (DriveId)((Object)object);
        if (driveId.zzgin != this.zzgin) {
            return false;
        }
        if (driveId.zzgjl == -1L && this.zzgjl == -1L) {
            return driveId.zzgjk.equals(this.zzgjk);
        }
        if (this.zzgjk == null || driveId.zzgjk == null) {
            return driveId.zzgjl == this.zzgjl;
        }
        if (driveId.zzgjl == this.zzgjl) {
            if (driveId.zzgjk.equals(this.zzgjk)) {
                return true;
            }
            zzgjj.zzv("DriveId", "Unexpected unequal resourceId for same DriveId object.");
        }
        return false;
    }

    public final String encodeToString() {
        if (this.zzgip == null) {
            DriveId driveId = this;
            zzbtf zzbtf2 = new zzbtf();
            new zzbtf().versionCode = 1;
            zzbtf2.zzgrt = driveId.zzgjk == null ? "" : driveId.zzgjk;
            zzbtf2.zzgru = driveId.zzgjl;
            zzbtf2.zzgrr = driveId.zzgin;
            zzbtf2.zzgrv = driveId.zzgjm;
            String string = Base64.encodeToString((byte[])zzfjs.zzc((zzfjs)zzbtf2), (int)10);
            String string2 = String.valueOf("DriveId:");
            String string3 = String.valueOf(string);
            this.zzgip = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        }
        return this.zzgip;
    }

    public final String toInvariantString() {
        if (this.zzgjn == null) {
            DriveId driveId = this;
            zzbtg zzbtg2 = new zzbtg();
            new zzbtg().zzgru = driveId.zzgjl;
            zzbtg2.zzgrr = driveId.zzgin;
            byte[] byArray = zzfjs.zzc((zzfjs)zzbtg2);
            this.zzgjn = Base64.encodeToString((byte[])byArray, (int)10);
        }
        return this.zzgjn;
    }

    public String toString() {
        return this.encodeToString();
    }

    public static DriveId decodeFromString(String string) {
        String string2 = String.valueOf(string);
        zzbq.checkArgument((boolean)string.startsWith("DriveId:"), (Object)(string2.length() != 0 ? "Invalid DriveId: ".concat(string2) : new String("Invalid DriveId: ")));
        return DriveId.zzn(Base64.decode((String)string.substring(8), (int)10));
    }

    private static DriveId zzn(byte[] byArray) {
        zzbtf zzbtf2;
        try {
            byte[] byArray2 = byArray;
            zzbtf2 = (zzbtf)zzfjs.zza((zzfjs)new zzbtf(), (byte[])byArray2);
        }
        catch (zzfjr zzfjr2) {
            throw new IllegalArgumentException();
        }
        String string = "".equals(zzbtf2.zzgrt) ? null : zzbtf2.zzgrt;
        return new DriveId(string, zzbtf2.zzgru, zzbtf2.zzgrr, zzbtf2.zzgrv);
    }
}

