/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.text.TextUtils;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.internal.zzbmo;
import java.util.Arrays;

public class ExecutionOptions {
    public static final int MAX_TRACKING_TAG_STRING_LENGTH = 65536;
    public static final int CONFLICT_STRATEGY_OVERWRITE_REMOTE = 0;
    public static final int CONFLICT_STRATEGY_KEEP_REMOTE = 1;
    private final String zzgju;
    private final boolean zzgjv;
    private final int zzgjw;

    public ExecutionOptions(String string, boolean bl, int n) {
        this.zzgju = string;
        this.zzgjv = bl;
        this.zzgjw = n;
    }

    public final String zzaoe() {
        return this.zzgju;
    }

    public final boolean zzaof() {
        return this.zzgjv;
    }

    public final int zzaog() {
        return this.zzgjw;
    }

    public static boolean zzcr(int n) {
        switch (n) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public final void zzf(GoogleApiClient googleApiClient) {
        zzbmo zzbmo2 = (zzbmo)googleApiClient.zza(Drive.zzebf);
        this.zza(zzbmo2);
    }

    public final void zza(zzbmo zzbmo2) {
        if (this.zzgjv && !zzbmo2.zzapc()) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to be notified on completion");
        }
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        if (object == this) {
            return true;
        }
        ExecutionOptions executionOptions = (ExecutionOptions)object;
        return zzbg.equal((Object)this.zzgju, (Object)executionOptions.zzgju) && this.zzgjw == executionOptions.zzgjw && this.zzgjv == executionOptions.zzgjv;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzgju, this.zzgjw, this.zzgjv});
    }

    public static class Builder {
        protected String zzgju;
        protected boolean zzgjv;
        protected int zzgjw = 0;

        public Builder() {
        }

        public Builder setTrackingTag(String string) {
            String string2 = string;
            if (!(!TextUtils.isEmpty((CharSequence)string2) && string2.length() <= 65536)) {
                throw new IllegalArgumentException(String.format("trackingTag must not be null nor empty, and the length must be <= the maximum length (%s)", 65536));
            }
            this.zzgju = string;
            return this;
        }

        public Builder setNotifyOnCompletion(boolean bl) {
            this.zzgjv = bl;
            return this;
        }

        public Builder setConflictStrategy(int n) {
            boolean bl;
            switch (n) {
                case 0: 
                case 1: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (!bl) {
                throw new IllegalArgumentException(new StringBuilder(53).append("Unrecognized value for conflict strategy: ").append(n).toString());
            }
            this.zzgjw = n;
            return this;
        }

        protected final void zzaoh() {
            if (this.zzgjw == 1 && !this.zzgjv) {
                throw new IllegalStateException("Cannot use CONFLICT_STRATEGY_KEEP_REMOTE without requesting completion notifications");
            }
        }

        public ExecutionOptions build() {
            this.zzaoh();
            return new ExecutionOptions(this.zzgju, this.zzgjv, this.zzgjw);
        }
    }
}

