/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.drive.metadata.CustomPropertyKey;
import com.google.android.gms.drive.metadata.MetadataField;
import com.google.android.gms.drive.metadata.internal.AppVisibleCustomProperties;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzbth;
import com.google.android.gms.internal.zzbtu;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public final class MetadataChangeSet {
    public static final int INDEXABLE_TEXT_SIZE_LIMIT_BYTES = 131072;
    public static final int CUSTOM_PROPERTY_SIZE_LIMIT_BYTES = 124;
    public static final int MAX_PUBLIC_PROPERTIES_PER_RESOURCE = 30;
    public static final int MAX_PRIVATE_PROPERTIES_PER_RESOURCE_PER_APP = 30;
    public static final int MAX_TOTAL_PROPERTIES_PER_RESOURCE = 100;
    public static final MetadataChangeSet zzgkc = new MetadataChangeSet(MetadataBundle.zzapp());
    private final MetadataBundle zzgkd;

    public MetadataChangeSet(MetadataBundle metadataBundle) {
        this.zzgkd = metadataBundle.zzapq();
    }

    public final Map<CustomPropertyKey, String> getCustomPropertyChangeMap() {
        AppVisibleCustomProperties appVisibleCustomProperties = this.zzgkd.zza(zzbth.zzgsn);
        if (appVisibleCustomProperties == null) {
            return Collections.emptyMap();
        }
        return appVisibleCustomProperties.zzapl();
    }

    public final String getDescription() {
        return this.zzgkd.zza(zzbth.zzgso);
    }

    public final String getIndexableText() {
        return this.zzgkd.zza(zzbth.zzgsu);
    }

    public final Date getLastViewedByMeDate() {
        return this.zzgkd.zza(zzbtu.zzgue);
    }

    public final String getMimeType() {
        return this.zzgkd.zza(zzbth.zzgti);
    }

    public final String getTitle() {
        return this.zzgkd.zza(zzbth.zzgtr);
    }

    public final Boolean isPinned() {
        return this.zzgkd.zza(zzbth.zzgta);
    }

    public final Boolean isStarred() {
        return this.zzgkd.zza(zzbth.zzgtp);
    }

    public final Boolean isViewed() {
        return this.zzgkd.zza(zzbth.zzgth);
    }

    public final MetadataBundle zzaol() {
        return this.zzgkd;
    }

    public final <T> MetadataChangeSet zza(MetadataField<T> metadataField, T t) {
        MetadataChangeSet metadataChangeSet = this;
        MetadataChangeSet metadataChangeSet2 = new MetadataChangeSet(metadataChangeSet.zzgkd);
        metadataChangeSet2.zzgkd.zzc(metadataField, t);
        return metadataChangeSet2;
    }

    public static class Builder {
        private final MetadataBundle zzgkd = MetadataBundle.zzapp();
        private AppVisibleCustomProperties.zza zzgke;

        public Builder() {
        }

        private final AppVisibleCustomProperties.zza zzaom() {
            if (this.zzgke == null) {
                this.zzgke = new AppVisibleCustomProperties.zza();
            }
            return this.zzgke;
        }

        private static int zzgw(String string) {
            if (string == null) {
                return 0;
            }
            return string.getBytes().length;
        }

        private static void zzi(String string, int n, int n2) {
            int n3 = n2;
            int n4 = n;
            String string2 = string;
            zzbq.checkArgument((n2 <= n ? 1 : 0) != 0, (Object)String.format("%s must be no more than %d bytes, but is %d bytes.", string2, n4, n3));
        }

        public Builder setCustomProperty(CustomPropertyKey customPropertyKey, String string) {
            zzbq.checkNotNull((Object)((Object)customPropertyKey), (Object)"key");
            zzbq.checkNotNull((Object)string, (Object)"value");
            int n = Builder.zzgw(customPropertyKey.getKey()) + Builder.zzgw(string);
            Builder.zzi("The total size of key string and value string of a custom property", 124, n);
            this.zzaom().zza(customPropertyKey, string);
            return this;
        }

        public Builder deleteCustomProperty(CustomPropertyKey customPropertyKey) {
            zzbq.checkNotNull((Object)((Object)customPropertyKey), (Object)"key");
            this.zzaom().zza(customPropertyKey, null);
            return this;
        }

        public Builder setDescription(String string) {
            this.zzgkd.zzc(zzbth.zzgso, string);
            return this;
        }

        public Builder setIndexableText(String string) {
            int n = Builder.zzgw(string);
            Builder.zzi("Indexable text size", 131072, n);
            this.zzgkd.zzc(zzbth.zzgsu, string);
            return this;
        }

        public Builder setLastViewedByMeDate(Date date) {
            this.zzgkd.zzc(zzbtu.zzgue, date);
            return this;
        }

        public Builder setMimeType(@NonNull String string) {
            zzbq.checkNotNull((Object)string);
            this.zzgkd.zzc(zzbth.zzgti, string);
            return this;
        }

        public Builder setPinned(boolean bl) {
            this.zzgkd.zzc(zzbth.zzgta, bl);
            return this;
        }

        public Builder setStarred(boolean bl) {
            this.zzgkd.zzc(zzbth.zzgtp, bl);
            return this;
        }

        public Builder setTitle(@NonNull String string) {
            zzbq.checkNotNull((Object)string, (Object)"Title cannot be null.");
            this.zzgkd.zzc(zzbth.zzgtr, string);
            return this;
        }

        @Deprecated
        public Builder setViewed(boolean bl) {
            if (bl) {
                this.zzgkd.zzc(zzbth.zzgth, true);
            } else if (this.zzgkd.zzd(zzbth.zzgth)) {
                this.zzgkd.zzc(zzbth.zzgth);
            }
            return this;
        }

        public Builder setViewed() {
            this.zzgkd.zzc(zzbth.zzgth, true);
            return this;
        }

        public MetadataChangeSet build() {
            if (this.zzgke != null) {
                this.zzgkd.zzc(zzbth.zzgsn, this.zzgke.zzapm());
            }
            return new MetadataChangeSet(this.zzgkd);
        }
    }
}

