/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import com.google.android.gms.drive.FileUploadPreferences;
import com.google.android.gms.drive.TransferPreferences;
import java.util.Arrays;

public class TransferPreferencesBuilder {
    public static final TransferPreferences DEFAULT_PREFERENCES = new zza(1, true, 256);
    private int zzgks;
    private boolean zzgkt;
    private int zzgku;

    public TransferPreferencesBuilder() {
        this(DEFAULT_PREFERENCES);
    }

    public TransferPreferencesBuilder(TransferPreferences transferPreferences) {
        this.zzgks = transferPreferences.getNetworkPreference();
        this.zzgkt = transferPreferences.isRoamingAllowed();
        this.zzgku = transferPreferences.getBatteryUsagePreference();
    }

    public TransferPreferencesBuilder(FileUploadPreferences fileUploadPreferences) {
        this.zzgks = fileUploadPreferences.getNetworkTypePreference();
        this.zzgkt = fileUploadPreferences.isRoamingAllowed();
        this.zzgku = fileUploadPreferences.getBatteryUsagePreference();
    }

    public TransferPreferencesBuilder setNetworkPreference(int n) {
        this.zzgks = n;
        return this;
    }

    public TransferPreferencesBuilder setIsRoamingAllowed(boolean bl) {
        this.zzgkt = bl;
        return this;
    }

    public TransferPreferencesBuilder setBatteryUsagePreference(int n) {
        this.zzgku = n;
        return this;
    }

    public TransferPreferences build() {
        return new zza(this.zzgks, this.zzgkt, this.zzgku);
    }

    static final class zza
    implements TransferPreferences {
        private final int zzgks;
        private final boolean zzgkt;
        private final int zzgku;

        zza(int n, boolean bl, int n2) {
            this.zzgks = n;
            this.zzgkt = bl;
            this.zzgku = n2;
        }

        @Override
        public final int getNetworkPreference() {
            return this.zzgks;
        }

        @Override
        public final boolean isRoamingAllowed() {
            return this.zzgkt;
        }

        @Override
        public final int getBatteryUsagePreference() {
            return this.zzgku;
        }

        public final int hashCode() {
            return Arrays.hashCode(new Object[]{this.zzgks, this.zzgkt, this.zzgku});
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            zza zza2 = (zza)object;
            return zza2.zzgks == this.zzgks && zza2.zzgkt == this.zzgkt && zza2.zzgku == this.zzgku;
        }

        public final String toString() {
            return String.format("NetworkPreference: %s, IsRoamingAllowed %s, BatteryUsagePreference %s", this.zzgks, this.zzgkt, this.zzgku);
        }
    }
}

