/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import com.google.android.gms.common.internal.zzal;
import com.google.android.gms.common.util.zzx;
import com.google.android.gms.drive.events.ChangeEvent;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.CompletionEvent;
import com.google.android.gms.drive.events.CompletionListener;
import com.google.android.gms.drive.events.DriveEvent;
import com.google.android.gms.drive.events.zzd;
import com.google.android.gms.drive.events.zzh;
import com.google.android.gms.drive.events.zzi;
import com.google.android.gms.drive.events.zzr;
import com.google.android.gms.internal.zzbqn;
import com.google.android.gms.internal.zzbrd;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class DriveEventService
extends Service
implements ChangeListener,
CompletionListener,
zzd,
zzi {
    private static final zzal zzgjj = new zzal("DriveEventService", "");
    public static final String ACTION_HANDLE_EVENT = "com.google.android.gms.drive.events.HANDLE_EVENT";
    private final String mName;
    private CountDownLatch zzglo;
    zza zzglp;
    boolean zzglq = false;
    private int zzglr = -1;

    protected DriveEventService(String string) {
        this.mName = string;
    }

    protected DriveEventService() {
        this(DriveEventService.class.getSimpleName());
    }

    public final synchronized IBinder onBind(Intent intent) {
        if (ACTION_HANDLE_EVENT.equals(intent.getAction())) {
            if (this.zzglp == null && !this.zzglq) {
                this.zzglq = true;
                CountDownLatch countDownLatch = new CountDownLatch(1);
                this.zzglo = new CountDownLatch(1);
                new zzh(this, countDownLatch).start();
                try {
                    if (!countDownLatch.await(5000L, TimeUnit.MILLISECONDS)) {
                        zzgjj.zzw("DriveEventService", "Failed to synchronously initialize event handler.");
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException("Unable to start event handler", interruptedException);
                }
            }
            return new zzb(this).asBinder();
        }
        return null;
    }

    public boolean onUnbind(Intent intent) {
        return true;
    }

    public synchronized void onDestroy() {
        zzgjj.zzu("DriveEventService", "onDestroy");
        if (this.zzglp != null) {
            Message message = this.zzglp.zzaot();
            this.zzglp.sendMessage(message);
            this.zzglp = null;
            try {
                if (!this.zzglo.await(5000L, TimeUnit.MILLISECONDS)) {
                    zzgjj.zzv("DriveEventService", "Failed to synchronously quit event handler. Will quit itself");
                }
            }
            catch (InterruptedException interruptedException) {}
            this.zzglo = null;
        }
        super.onDestroy();
    }

    @Override
    public void onChange(ChangeEvent changeEvent) {
        zzgjj.zzc("DriveEventService", "Unhandled change event in %s: %s", new Object[]{this.mName, changeEvent});
    }

    @Override
    public final void zza(com.google.android.gms.drive.events.zzb zzb2) {
        zzgjj.zzc("DriveEventService", "Unhandled changes available event in %s: %s", new Object[]{this.mName, zzb2});
    }

    @Override
    public void onCompletion(CompletionEvent completionEvent) {
        zzgjj.zzc("DriveEventService", "Unhandled completion event in %s: %s", new Object[]{this.mName, completionEvent});
    }

    protected int getCallingUid() {
        return Binder.getCallingUid();
    }

    private final void zza(zzbrd zzbrd2) {
        DriveEvent driveEvent = zzbrd2.zzapg();
        zzgjj.zzb("DriveEventService", "handleEventMessage: %s", new Object[]{driveEvent});
        try {
            switch (driveEvent.getType()) {
                case 1: {
                    this.onChange((ChangeEvent)driveEvent);
                    return;
                }
                case 2: {
                    this.onCompletion((CompletionEvent)driveEvent);
                    return;
                }
                case 4: {
                    this.zza((com.google.android.gms.drive.events.zzb)driveEvent);
                    return;
                }
                case 7: {
                    zzr zzr2 = (zzr)driveEvent;
                    DriveEventService driveEventService = this;
                    zzgjj.zzc("DriveEventService", "Unhandled transfer state event in %s: %s", new Object[]{driveEventService.mName, zzr2});
                    return;
                }
            }
            zzgjj.zzc("DriveEventService", "Unhandled event: %s", new Object[]{driveEvent});
            return;
        }
        catch (Exception exception) {
            zzgjj.zzd("DriveEventService", String.format("Error handling event in %s", this.mName), (Throwable)exception);
            return;
        }
    }

    private final void zzaor() throws SecurityException {
        int n = this.getCallingUid();
        if (n == this.zzglr) {
            return;
        }
        if (zzx.zzf((Context)this, (int)n)) {
            this.zzglr = n;
            return;
        }
        throw new SecurityException("Caller is not GooglePlayServices");
    }

    static /* synthetic */ CountDownLatch zzb(DriveEventService driveEventService) {
        return driveEventService.zzglo;
    }

    final class zzb
    extends zzbqn {
        private /* synthetic */ DriveEventService zzglt;

        zzb(DriveEventService driveEventService) {
            this.zzglt = driveEventService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void zzc(zzbrd zzbrd2) throws RemoteException {
            DriveEventService driveEventService = this.zzglt;
            synchronized (driveEventService) {
                zzgjj.zzb("DriveEventService", "onEvent: %s", new Object[]{zzbrd2});
                this.zzglt.zzaor();
                if (this.zzglt.zzglp != null) {
                    Message message = this.zzglt.zzglp.zzb(zzbrd2);
                    this.zzglt.zzglp.sendMessage(message);
                } else {
                    zzgjj.zzw("DriveEventService", "Receiving event before initialize is completed.");
                }
                return;
            }
        }
    }

    final class zza
    extends Handler {
        private /* synthetic */ DriveEventService zzglt;

        zza(DriveEventService driveEventService) {
            this.zzglt = driveEventService;
        }

        private final Message zzb(zzbrd zzbrd2) {
            return this.obtainMessage(1, (Object)zzbrd2);
        }

        private final Message zzaot() {
            return this.obtainMessage(2);
        }

        public final void handleMessage(Message message) {
            zzgjj.zzb("DriveEventService", "handleMessage message type: %s", new Object[]{message.what});
            switch (message.what) {
                case 1: {
                    this.zzglt.zza((zzbrd)((Object)message.obj));
                    return;
                }
                case 2: {
                    this.getLooper().quit();
                    return;
                }
            }
            zzgjj.zzc("DriveEventService", "Unexpected message type: %s", new Object[]{message.what});
        }
    }
}

