/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.ParcelFileDescriptor;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.internal.zzal;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzn;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.zzc;
import com.google.android.gms.drive.zzr;
import com.google.android.gms.drive.zzt;
import com.google.android.gms.internal.zzbmz;
import com.google.android.gms.internal.zzbna;
import com.google.android.gms.internal.zzbnb;
import com.google.android.gms.internal.zzbnc;
import java.io.InputStream;
import java.io.OutputStream;

public final class zzbmy
implements DriveContents {
    private static final zzal zzgjj = new zzal("DriveContentsImpl", "");
    private final zzc zzgnz;
    private boolean mClosed = false;
    private boolean zzgoa = false;
    private boolean zzgob = false;

    public zzbmy(zzc zzc2) {
        this.zzgnz = (zzc)((Object)zzbq.checkNotNull((Object)((Object)zzc2)));
    }

    @Override
    public final DriveId getDriveId() {
        return this.zzgnz.getDriveId();
    }

    @Override
    public final int getMode() {
        return this.zzgnz.getMode();
    }

    @Override
    public final ParcelFileDescriptor getParcelFileDescriptor() {
        if (this.mClosed) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        return this.zzgnz.getParcelFileDescriptor();
    }

    @Override
    public final InputStream getInputStream() {
        if (this.mClosed) {
            throw new IllegalStateException("Contents have been closed, cannot access the input stream.");
        }
        if (this.zzgnz.getMode() != 0x10000000) {
            throw new IllegalStateException("getInputStream() can only be used with contents opened with MODE_READ_ONLY.");
        }
        if (this.zzgoa) {
            throw new IllegalStateException("getInputStream() can only be called once per Contents instance.");
        }
        this.zzgoa = true;
        return this.zzgnz.getInputStream();
    }

    @Override
    public final OutputStream getOutputStream() {
        if (this.mClosed) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        if (this.zzgnz.getMode() != 0x20000000) {
            throw new IllegalStateException("getOutputStream() can only be used with contents opened with MODE_WRITE_ONLY.");
        }
        if (this.zzgob) {
            throw new IllegalStateException("getOutputStream() can only be called once per Contents instance.");
        }
        this.zzgob = true;
        return this.zzgnz.getOutputStream();
    }

    @Override
    public final PendingResult<DriveApi.DriveContentsResult> reopenForWrite(GoogleApiClient googleApiClient) {
        if (this.mClosed) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.zzgnz.getMode() != 0x10000000) {
            throw new IllegalStateException("reopenForWrite can only be used with DriveContents opened with MODE_READ_ONLY.");
        }
        this.zzaoc();
        return googleApiClient.zzd((zzm)new zzbmz(this, googleApiClient));
    }

    @Override
    public final PendingResult<Status> commit(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet) {
        return this.zza(googleApiClient, metadataChangeSet, null);
    }

    @Override
    public final PendingResult<Status> commit(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, ExecutionOptions executionOptions) {
        return this.zza(googleApiClient, metadataChangeSet, executionOptions == null ? null : zzr.zzb(executionOptions));
    }

    private final PendingResult<Status> zza(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, zzr zzr2) {
        if (zzr2 == null) {
            zzr2 = (zzr)((ExecutionOptions.Builder)new zzt()).build();
        }
        if (this.zzgnz.getMode() == 0x10000000) {
            throw new IllegalStateException("Cannot commit contents opened with MODE_READ_ONLY");
        }
        if (ExecutionOptions.zzcr(zzr2.zzaog()) && !this.zzgnz.zzant()) {
            throw new IllegalStateException("DriveContents must be valid for conflict detection.");
        }
        zzr2.zzf(googleApiClient);
        if (this.mClosed) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.getDriveId() == null) {
            throw new IllegalStateException("Only DriveContents obtained through DriveFile.open can be committed.");
        }
        MetadataChangeSet metadataChangeSet2 = metadataChangeSet != null ? metadataChangeSet : MetadataChangeSet.zzgkc;
        zzr zzr3 = zzr2;
        this.zzaoc();
        return googleApiClient.zze((zzm)new zzbna(this, googleApiClient, metadataChangeSet2, zzr3));
    }

    @Override
    public final void discard(GoogleApiClient googleApiClient) {
        if (this.mClosed) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        this.zzaoc();
        ((zzbnc)googleApiClient.zze((zzm)new zzbnc(this, googleApiClient))).setResultCallback(new zzbnb(this));
    }

    @Override
    public final zzc zzaob() {
        return this.zzgnz;
    }

    @Override
    public final void zzaoc() {
        zzn.zza((ParcelFileDescriptor)this.zzgnz.getParcelFileDescriptor());
        this.mClosed = true;
    }

    @Override
    public final boolean zzaod() {
        return this.mClosed;
    }

    static /* synthetic */ zzc zza(zzbmy zzbmy2) {
        return zzbmy2.zzgnz;
    }

    static /* synthetic */ zzal zzapd() {
        return zzgjj;
    }
}

