/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.zzj;
import com.google.android.gms.internal.zzbkw;
import com.google.android.gms.internal.zzbmo;
import com.google.android.gms.internal.zzbmr;
import com.google.android.gms.internal.zzbms;
import com.google.android.gms.internal.zzbpk;
import com.google.android.gms.internal.zzbpl;
import com.google.android.gms.internal.zzbpm;
import com.google.android.gms.internal.zzbpn;
import com.google.android.gms.internal.zzbpo;
import com.google.android.gms.internal.zzbpp;
import com.google.android.gms.internal.zzbpq;
import java.util.ArrayList;
import java.util.Set;

public class zzbpj
implements DriveResource {
    protected final DriveId zzgis;

    public zzbpj(DriveId driveId) {
        this.zzgis = driveId;
    }

    @Override
    public DriveId getDriveId() {
        return this.zzgis;
    }

    @Override
    public PendingResult<DriveResource.MetadataResult> getMetadata(GoogleApiClient googleApiClient) {
        GoogleApiClient googleApiClient2 = googleApiClient;
        zzbpj zzbpj2 = this;
        return googleApiClient2.zzd((zzm)new zzbpk(zzbpj2, googleApiClient2, false));
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> listParents(GoogleApiClient googleApiClient) {
        return googleApiClient.zzd((zzm)new zzbpl(this, googleApiClient));
    }

    @Override
    public PendingResult<Status> setParents(GoogleApiClient googleApiClient, Set<DriveId> set) {
        if (set == null) {
            throw new IllegalArgumentException("ParentIds must be provided.");
        }
        ArrayList<DriveId> arrayList = new ArrayList<DriveId>(set);
        return googleApiClient.zze((zzm)new zzbpm(this, googleApiClient, arrayList));
    }

    @Override
    public PendingResult<DriveResource.MetadataResult> updateMetadata(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet) {
        if (metadataChangeSet == null) {
            throw new IllegalArgumentException("ChangeSet must be provided.");
        }
        return googleApiClient.zze((zzm)new zzbpn(this, googleApiClient, metadataChangeSet));
    }

    @Override
    public PendingResult<Status> delete(GoogleApiClient googleApiClient) {
        return googleApiClient.zze((zzm)new zzbpo(this, googleApiClient));
    }

    @Override
    public PendingResult<Status> addChangeListener(GoogleApiClient googleApiClient, ChangeListener changeListener) {
        return ((zzbmo)googleApiClient.zza(Drive.zzebf)).zza(googleApiClient, this.zzgis, changeListener);
    }

    @Override
    public PendingResult<Status> removeChangeListener(GoogleApiClient googleApiClient, ChangeListener changeListener) {
        return ((zzbmo)googleApiClient.zza(Drive.zzebf)).zzb(googleApiClient, this.zzgis, changeListener);
    }

    @Override
    public PendingResult<Status> addChangeSubscription(GoogleApiClient googleApiClient) {
        DriveId driveId = this.zzgis;
        GoogleApiClient googleApiClient2 = googleApiClient;
        zzbmo zzbmo2 = (zzbmo)googleApiClient.zza(Drive.zzebf);
        zzbkw zzbkw2 = new zzbkw(1, driveId);
        GoogleApiClient googleApiClient3 = googleApiClient2;
        zzbmo zzbmo3 = zzbmo2;
        zzbq.checkArgument((boolean)zzj.zza(zzbkw2.zzgdm, zzbkw2.zzgis));
        zzbq.zza((boolean)zzbmo3.isConnected(), (Object)"Client must be connected");
        if (!zzbmo3.zzgnh) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to add event subscriptions");
        }
        return googleApiClient3.zze((zzm)new zzbmr(zzbmo3, googleApiClient3, zzbkw2));
    }

    @Override
    public PendingResult<Status> removeChangeSubscription(GoogleApiClient googleApiClient) {
        DriveId driveId = this.zzgis;
        GoogleApiClient googleApiClient2 = googleApiClient;
        zzbmo zzbmo2 = (zzbmo)googleApiClient.zza(Drive.zzebf);
        DriveId driveId2 = driveId;
        GoogleApiClient googleApiClient3 = googleApiClient2;
        zzbmo zzbmo3 = zzbmo2;
        zzbq.checkArgument((boolean)zzj.zza(1, driveId2));
        zzbq.zza((boolean)zzbmo3.isConnected(), (Object)"Client must be connected");
        return googleApiClient3.zze((zzm)new zzbms(zzbmo3, googleApiClient3, driveId2, 1));
    }

    @Override
    public PendingResult<Status> trash(GoogleApiClient googleApiClient) {
        return googleApiClient.zze((zzm)new zzbpp(this, googleApiClient));
    }

    @Override
    public PendingResult<Status> untrash(GoogleApiClient googleApiClient) {
        return googleApiClient.zze((zzm)new zzbpq(this, googleApiClient));
    }
}

