/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzal;
import com.google.android.gms.common.util.zzn;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ResourceEvent;
import com.google.android.gms.drive.events.zzg;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import com.google.android.gms.internal.zzbqp;
import com.google.android.gms.internal.zzbth;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class CompletionEvent
extends zzbfm
implements ResourceEvent {
    private static final zzal zzgjj = new zzal("CompletionEvent", "");
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_FAILURE = 1;
    public static final int STATUS_CONFLICT = 2;
    public static final int STATUS_CANCELED = 3;
    public static final Parcelable.Creator<CompletionEvent> CREATOR = new zzg();
    private DriveId zzgis;
    private String zzebv;
    private ParcelFileDescriptor zzglg;
    private ParcelFileDescriptor zzglh;
    private MetadataBundle zzgli;
    private List<String> zzglj;
    private int zzcbc;
    private IBinder zzglk;
    private boolean zzgll = false;
    private boolean zzglm = false;
    private boolean zzgln = false;

    CompletionEvent(DriveId driveId, String string, ParcelFileDescriptor parcelFileDescriptor, ParcelFileDescriptor parcelFileDescriptor2, MetadataBundle metadataBundle, List<String> list, int n, IBinder iBinder) {
        this.zzgis = driveId;
        this.zzebv = string;
        this.zzglg = parcelFileDescriptor;
        this.zzglh = parcelFileDescriptor2;
        this.zzgli = metadataBundle;
        this.zzglj = list;
        this.zzcbc = n;
        this.zzglk = iBinder;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        int n2 = n | 1;
        Parcel parcel2 = parcel;
        CompletionEvent completionEvent = this;
        int n3 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)2, (Parcelable)completionEvent.zzgis, (int)n2, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)3, (String)completionEvent.zzebv, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)4, (Parcelable)completionEvent.zzglg, (int)n2, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)5, (Parcelable)completionEvent.zzglh, (int)n2, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)6, (Parcelable)completionEvent.zzgli, (int)n2, (boolean)false);
        zzbfp.zzb((Parcel)parcel2, (int)7, completionEvent.zzglj, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)8, (int)completionEvent.zzcbc);
        zzbfp.zza((Parcel)parcel2, (int)9, (IBinder)completionEvent.zzglk, (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n3);
    }

    @Override
    public final int getType() {
        return 2;
    }

    @Override
    public final DriveId getDriveId() {
        this.zzaoq();
        return this.zzgis;
    }

    public final String getAccountName() {
        this.zzaoq();
        return this.zzebv;
    }

    public final InputStream getBaseContentsInputStream() {
        this.zzaoq();
        if (this.zzglg == null) {
            return null;
        }
        if (this.zzgll) {
            throw new IllegalStateException("getBaseInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzgll = true;
        return new FileInputStream(this.zzglg.getFileDescriptor());
    }

    public final InputStream getModifiedContentsInputStream() {
        this.zzaoq();
        if (this.zzglh == null) {
            return null;
        }
        if (this.zzglm) {
            throw new IllegalStateException("getModifiedInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzglm = true;
        return new FileInputStream(this.zzglh.getFileDescriptor());
    }

    public final MetadataChangeSet getModifiedMetadataChangeSet() {
        this.zzaoq();
        if (this.zzgli != null) {
            return new MetadataChangeSet(this.zzgli);
        }
        return null;
    }

    public final List<String> getTrackingTags() {
        this.zzaoq();
        return new ArrayList<String>(this.zzglj);
    }

    public final int getStatus() {
        this.zzaoq();
        return this.zzcbc;
    }

    public final void dismiss() {
        this.zzab(false);
    }

    public final void snooze() {
        this.zzab(true);
    }

    private final void zzab(boolean bl) {
        this.zzaoq();
        this.zzgln = true;
        zzn.zza((ParcelFileDescriptor)this.zzglg);
        zzn.zza((ParcelFileDescriptor)this.zzglh);
        if (this.zzgli != null && this.zzgli.zzd(zzbth.zzgtq)) {
            this.zzgli.zza(zzbth.zzgtq).release();
        }
        if (this.zzglk == null) {
            String string = bl ? "snooze" : "dismiss";
            zzgjj.zzd("CompletionEvent", "No callback on %s", new Object[]{string});
            return;
        }
        try {
            zzbqp.zzao(this.zzglk).zzab(bl);
            return;
        }
        catch (RemoteException remoteException) {
            String string = bl ? "snooze" : "dismiss";
            zzgjj.zzd("CompletionEvent", String.format("RemoteException on %s", string), (Throwable)remoteException);
            return;
        }
    }

    private final void zzaoq() {
        if (this.zzgln) {
            throw new IllegalStateException("Event has already been dismissed or snoozed.");
        }
    }

    public final String toString() {
        String string;
        if (this.zzglj == null) {
            string = "<null>";
        } else {
            String string2 = TextUtils.join((CharSequence)"','", this.zzglj);
            string = new StringBuilder(2 + String.valueOf(string2).length()).append("'").append(string2).append("'").toString();
        }
        String string3 = string;
        return String.format(Locale.US, "CompletionEvent [id=%s, status=%s, trackingTag=%s]", new Object[]{this.zzgis, this.zzcbc, string3});
    }
}

