/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.metadata;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.drive.metadata.zzc;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class CustomPropertyKey
extends zzbfm {
    public static final Parcelable.Creator<CustomPropertyKey> CREATOR = new zzc();
    public static final int PUBLIC = 0;
    public static final int PRIVATE = 1;
    private String zzbhb;
    private int mVisibility;
    private static final Pattern zzgsa = Pattern.compile("[\\w.!@$%^&*()/-]+");

    public CustomPropertyKey(String string, int n) {
        zzbq.checkNotNull((Object)string, (Object)"key");
        zzbq.checkArgument((boolean)zzgsa.matcher(string).matches(), (Object)"key name characters must be alphanumeric or one of .!@$%^&*()-_/");
        zzbq.checkArgument((n == 0 || n == 1 ? 1 : 0) != 0, (Object)"visibility must be either PUBLIC or PRIVATE");
        this.zzbhb = string;
        this.mVisibility = n;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CustomPropertyKey customPropertyKey = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)2, (String)customPropertyKey.zzbhb, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)3, (int)customPropertyKey.mVisibility);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public String getKey() {
        return this.zzbhb;
    }

    public int getVisibility() {
        return this.mVisibility;
    }

    public int hashCode() {
        String string = this.zzbhb;
        int n = this.mVisibility;
        return new StringBuilder(11 + String.valueOf(string).length()).append(string).append(n).toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        CustomPropertyKey customPropertyKey = (CustomPropertyKey)((Object)object);
        return customPropertyKey.getKey().equals(this.zzbhb) && customPropertyKey.getVisibility() == this.mVisibility;
    }

    public String toString() {
        String string = this.zzbhb;
        int n = this.mVisibility;
        return new StringBuilder(31 + String.valueOf(string).length()).append("CustomPropertyKey(").append(string).append(",").append(n).append(")").toString();
    }

    public JSONObject toJson() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("key", (Object)this.getKey());
        jSONObject.put("visibility", this.getVisibility());
        return jSONObject;
    }

    public static CustomPropertyKey fromJson(JSONObject jSONObject) throws JSONException {
        return new CustomPropertyKey(jSONObject.getString("key"), jSONObject.getInt("visibility"));
    }
}

