/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.metadata.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzal;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.drive.metadata.MetadataField;
import com.google.android.gms.drive.metadata.internal.zzf;
import com.google.android.gms.drive.metadata.internal.zzj;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import com.google.android.gms.internal.zzbth;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public final class MetadataBundle
extends zzbfm
implements ReflectedParcelable {
    private static final zzal zzgjj = new zzal("MetadataBundle", "");
    public static final Parcelable.Creator<MetadataBundle> CREATOR = new zzj();
    private Bundle zzgsh;

    MetadataBundle(Bundle bundle) {
        this.zzgsh = (Bundle)zzbq.checkNotNull((Object)bundle);
        this.zzgsh.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.zzgsh.keySet()) {
            if (zzf.zzgx(string) != null) continue;
            arrayList.add(string);
            zzgjj.zzc("MetadataBundle", "Ignored unknown metadata field in bundle: %s", new Object[]{string});
        }
        ArrayList<String> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            String string;
            Object e = arrayList2.get(i);
            string = (String)e;
            this.zzgsh.remove(string);
        }
    }

    public static MetadataBundle zzapp() {
        return new MetadataBundle(new Bundle());
    }

    public static <T> MetadataBundle zzb(MetadataField<T> metadataField, T t) {
        MetadataBundle metadataBundle = MetadataBundle.zzapp();
        metadataBundle.zzc(metadataField, t);
        return metadataBundle;
    }

    public final MetadataBundle zzapq() {
        return new MetadataBundle(new Bundle(this.zzgsh));
    }

    public final <T> void zzc(MetadataField<T> metadataField, T t) {
        if (zzf.zzgx(metadataField.getName()) == null) {
            String string = String.valueOf(metadataField.getName());
            throw new IllegalArgumentException(string.length() != 0 ? "Unregistered field: ".concat(string) : new String("Unregistered field: "));
        }
        metadataField.zza(t, this.zzgsh);
    }

    public final <T> T zza(MetadataField<T> metadataField) {
        return metadataField.zzm(this.zzgsh);
    }

    public final <T> T zzc(MetadataField<T> metadataField) {
        T t = this.zza(metadataField);
        this.zzgsh.remove(metadataField.getName());
        return t;
    }

    public final boolean zzd(MetadataField<?> metadataField) {
        return this.zzgsh.containsKey(metadataField.getName());
    }

    public final Set<MetadataField<?>> zzapr() {
        HashSet hashSet = new HashSet();
        for (String string : this.zzgsh.keySet()) {
            hashSet.add(zzf.zzgx(string));
        }
        return hashSet;
    }

    public final void setContext(Context context) {
        BitmapTeleporter bitmapTeleporter = this.zza(zzbth.zzgtq);
        if (bitmapTeleporter != null) {
            bitmapTeleporter.setTempDir(context.getCacheDir());
        }
    }

    public final int hashCode() {
        int n = 1;
        for (String string : this.zzgsh.keySet()) {
            n = n * 31 + this.zzgsh.get(string).hashCode();
        }
        return n;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        MetadataBundle metadataBundle = (MetadataBundle)((Object)object);
        Set set = this.zzgsh.keySet();
        if (!set.equals(metadataBundle.zzgsh.keySet())) {
            return false;
        }
        for (String string : set) {
            if (zzbg.equal((Object)this.zzgsh.get(string), (Object)metadataBundle.zzgsh.get(string))) continue;
            return false;
        }
        return true;
    }

    public final String toString() {
        String string = String.valueOf(this.zzgsh);
        return new StringBuilder(24 + String.valueOf(string).length()).append("MetadataBundle [values=").append(string).append("]").toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        MetadataBundle metadataBundle = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)2, (Bundle)metadataBundle.zzgsh, (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }
}

