/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.query;

import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.drive.metadata.CustomPropertyKey;
import com.google.android.gms.drive.metadata.SearchableCollectionMetadataField;
import com.google.android.gms.drive.metadata.SearchableMetadataField;
import com.google.android.gms.drive.metadata.SearchableOrderedMetadataField;
import com.google.android.gms.drive.metadata.internal.AppVisibleCustomProperties;
import com.google.android.gms.drive.query.Filter;
import com.google.android.gms.drive.query.SearchableField;
import com.google.android.gms.drive.query.internal.zzb;
import com.google.android.gms.drive.query.internal.zzd;
import com.google.android.gms.drive.query.internal.zzn;
import com.google.android.gms.drive.query.internal.zzp;
import com.google.android.gms.drive.query.internal.zzr;
import com.google.android.gms.drive.query.internal.zzv;
import com.google.android.gms.drive.query.internal.zzx;
import com.google.android.gms.drive.query.internal.zzz;

public class Filters {
    public Filters() {
    }

    public static <T> Filter eq(@NonNull SearchableMetadataField<T> searchableMetadataField, @NonNull T t) {
        zzbq.checkNotNull(searchableMetadataField, (Object)"Field may not be null.");
        zzbq.checkNotNull(t, (Object)"Value may not be null.");
        return new zzb<T>(zzx.zzgvp, searchableMetadataField, t);
    }

    public static <T extends Comparable<T>> Filter lessThan(@NonNull SearchableOrderedMetadataField<T> searchableOrderedMetadataField, @NonNull T t) {
        zzbq.checkNotNull(searchableOrderedMetadataField, (Object)"Field may not be null.");
        zzbq.checkNotNull(t, (Object)"Value may not be null.");
        return new zzb<T>(zzx.zzgvq, searchableOrderedMetadataField, t);
    }

    public static <T extends Comparable<T>> Filter greaterThan(@NonNull SearchableOrderedMetadataField<T> searchableOrderedMetadataField, @NonNull T t) {
        zzbq.checkNotNull(searchableOrderedMetadataField, (Object)"Field may not be null.");
        zzbq.checkNotNull(t, (Object)"Value may not be null.");
        return new zzb<T>(zzx.zzgvs, searchableOrderedMetadataField, t);
    }

    public static <T extends Comparable<T>> Filter lessThanEquals(@NonNull SearchableOrderedMetadataField<T> searchableOrderedMetadataField, @NonNull T t) {
        zzbq.checkNotNull(searchableOrderedMetadataField, (Object)"Field may not be null.");
        zzbq.checkNotNull(t, (Object)"Value may not be null.");
        return new zzb<T>(zzx.zzgvr, searchableOrderedMetadataField, t);
    }

    public static <T extends Comparable<T>> Filter greaterThanEquals(@NonNull SearchableOrderedMetadataField<T> searchableOrderedMetadataField, @NonNull T t) {
        zzbq.checkNotNull(searchableOrderedMetadataField, (Object)"Field may not be null.");
        zzbq.checkNotNull(t, (Object)"Value may not be null.");
        return new zzb<T>(zzx.zzgvt, searchableOrderedMetadataField, t);
    }

    public static <T> Filter in(@NonNull SearchableCollectionMetadataField<T> searchableCollectionMetadataField, @NonNull T t) {
        zzbq.checkNotNull(searchableCollectionMetadataField, (Object)"Field may not be null.");
        zzbq.checkNotNull(t, (Object)"Value may not be null.");
        return new zzp<T>(searchableCollectionMetadataField, t);
    }

    public static Filter eq(@NonNull CustomPropertyKey customPropertyKey, @NonNull String string) {
        zzbq.checkNotNull((Object)((Object)customPropertyKey), (Object)"Custom property key may not be null.");
        zzbq.checkNotNull((Object)string, (Object)"Custom property value may not be null.");
        return new zzn<AppVisibleCustomProperties>(SearchableField.zzguu, new AppVisibleCustomProperties.zza().zza(customPropertyKey, string).zzapm());
    }

    public static Filter contains(@NonNull SearchableMetadataField<String> searchableMetadataField, @NonNull String string) {
        zzbq.checkNotNull(searchableMetadataField, (Object)"Field may not be null.");
        zzbq.checkNotNull((Object)string, (Object)"Value may not be null.");
        return new zzb<String>(zzx.zzgvx, searchableMetadataField, string);
    }

    public static Filter and(@NonNull Filter filter, Filter ... filterArray) {
        zzbq.checkNotNull((Object)filter, (Object)"Filter may not be null.");
        zzbq.checkNotNull((Object)filterArray, (Object)"Additional filters may not be null.");
        return new zzr(zzx.zzgvu, filter, filterArray);
    }

    public static Filter and(@NonNull Iterable<Filter> iterable) {
        zzbq.checkNotNull(iterable, (Object)"Filters may not be null");
        return new zzr(zzx.zzgvu, iterable);
    }

    public static Filter or(@NonNull Filter filter, Filter ... filterArray) {
        zzbq.checkNotNull((Object)filter, (Object)"Filter may not be null.");
        zzbq.checkNotNull((Object)filterArray, (Object)"Additional filters may not be null.");
        return new zzr(zzx.zzgvv, filter, filterArray);
    }

    public static Filter or(@NonNull Iterable<Filter> iterable) {
        zzbq.checkNotNull(iterable, (Object)"Filters may not be null");
        return new zzr(zzx.zzgvv, iterable);
    }

    public static Filter not(@NonNull Filter filter) {
        zzbq.checkNotNull((Object)filter, (Object)"Filter may not be null");
        return new zzv(filter);
    }

    public static Filter sharedWithMe() {
        return new zzd(SearchableField.zzgut);
    }

    public static Filter openedByMe() {
        return new zzd(SearchableField.LAST_VIEWED_BY_ME);
    }

    public static Filter ownedByMe() {
        return new zzz();
    }
}

