/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.util.zzx;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.zzd;
import com.google.android.gms.drive.events.zzj;
import com.google.android.gms.internal.zzbkw;
import com.google.android.gms.internal.zzblq;
import com.google.android.gms.internal.zzbmi;
import com.google.android.gms.internal.zzbmp;
import com.google.android.gms.internal.zzbmq;
import com.google.android.gms.internal.zzbpy;
import com.google.android.gms.internal.zzbqi;
import com.google.android.gms.internal.zzbqj;
import com.google.android.gms.internal.zzbsg;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class zzbmo
extends zzab<zzbqi> {
    private final String zzebs;
    private final Bundle zzgjf;
    protected final boolean zzgnh;
    private volatile DriveId zzgni;
    private volatile DriveId zzgnj;
    private volatile boolean zzgnk = false;
    private GoogleApiClient.ConnectionCallbacks zzgnl;
    private Map<DriveId, Map<ChangeListener, zzbpy>> zzgnm = new HashMap<DriveId, Map<ChangeListener, zzbpy>>();
    private Map<zzd, zzbpy> zzgnn = new HashMap<zzd, zzbpy>();
    private Map<DriveId, Map<Object, zzbpy>> zzgno = new HashMap<DriveId, Map<Object, zzbpy>>();
    private Map<DriveId, Map<Object, zzbpy>> zzgnp = new HashMap<DriveId, Map<Object, zzbpy>>();

    public zzbmo(Context context, Looper looper, zzr zzr2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, Bundle bundle) {
        super(context, looper, 11, zzr2, connectionCallbacks, onConnectionFailedListener);
        this.zzebs = zzr2.zzaky();
        this.zzgnl = connectionCallbacks;
        this.zzgjf = bundle;
        Intent intent = new Intent("com.google.android.gms.drive.events.HANDLE_EVENT");
        intent.setPackage(context.getPackageName());
        List list = context.getPackageManager().queryIntentServices(intent, 0);
        switch (list.size()) {
            case 0: {
                this.zzgnh = false;
                return;
            }
            case 1: {
                ServiceInfo serviceInfo = ((ResolveInfo)list.get((int)0)).serviceInfo;
                if (!serviceInfo.exported) {
                    String string = serviceInfo.name;
                    throw new IllegalStateException(new StringBuilder(60 + String.valueOf(string).length()).append("Drive event service ").append(string).append(" must be exported in AndroidManifest.xml").toString());
                }
                this.zzgnh = true;
                return;
            }
        }
        String string = intent.getAction();
        throw new IllegalStateException(new StringBuilder(72 + String.valueOf(string).length()).append("AndroidManifest.xml can only define one service that handles the ").append(string).append(" action").toString());
    }

    public final boolean zzaay() {
        return !this.getContext().getPackageName().equals(this.zzebs) || !zzx.zzf((Context)this.getContext(), (int)Process.myUid());
    }

    public final boolean zzako() {
        return true;
    }

    protected final String zzhj() {
        return "com.google.android.gms.drive.internal.IDriveService";
    }

    protected final Bundle zzaap() {
        String string = this.getContext().getPackageName();
        zzbq.checkNotNull((Object)string);
        zzbq.checkState((!this.zzalh().zzakw().isEmpty() ? 1 : 0) != 0);
        Bundle bundle = new Bundle();
        if (!string.equals(this.zzebs)) {
            bundle.putString("proxy_package_name", this.zzebs);
        }
        bundle.putAll(this.zzgjf);
        return bundle;
    }

    protected final String zzhi() {
        return "com.google.android.gms.drive.ApiService.START";
    }

    public final DriveId zzaoz() {
        return this.zzgni;
    }

    public final DriveId zzapa() {
        return this.zzgnj;
    }

    public final boolean zzapb() {
        return this.zzgnk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disconnect() {
        if (this.isConnected()) {
            try {
                ((zzbqi)this.zzakn()).zza(new zzblq());
            }
            catch (RemoteException remoteException) {}
        }
        super.disconnect();
        Map<Object, Object> map = this.zzgnm;
        synchronized (map) {
            this.zzgnm.clear();
        }
        map = this.zzgnn;
        synchronized (map) {
            this.zzgnn.clear();
        }
        map = this.zzgno;
        synchronized (map) {
            this.zzgno.clear();
        }
        map = this.zzgnp;
        synchronized (map) {
            this.zzgnp.clear();
            return;
        }
    }

    protected final void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (bundle != null) {
            bundle.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.zzgni = (DriveId)bundle.getParcelable("com.google.android.gms.drive.root_id");
            this.zzgnj = (DriveId)bundle.getParcelable("com.google.android.gms.drive.appdata_id");
            this.zzgnk = true;
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public final boolean zzapc() {
        return this.zzgnh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        zzbq.checkArgument((boolean)zzj.zza(1, driveId));
        zzbq.checkNotNull((Object)changeListener, (Object)"listener");
        zzbq.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        Map<DriveId, Map<ChangeListener, zzbpy>> map = this.zzgnm;
        synchronized (map) {
            zzbpy zzbpy2;
            Map<ChangeListener, zzbpy> map2 = this.zzgnm.get((Object)driveId);
            if (map2 == null) {
                map2 = new HashMap<ChangeListener, zzbpy>();
                this.zzgnm.put(driveId, map2);
            }
            if ((zzbpy2 = map2.get(changeListener)) == null) {
                zzbpy2 = new zzbpy(this.getLooper(), this.getContext(), 1, changeListener);
                map2.put(changeListener, zzbpy2);
            } else if (zzbpy2.zzcw(1)) {
                return new zzbmi(googleApiClient, Status.zzfni);
            }
            zzbpy2.zzcv(1);
            zzbpy zzbpy3 = zzbpy2;
            zzbkw zzbkw2 = new zzbkw(1, driveId);
            GoogleApiClient googleApiClient2 = googleApiClient;
            zzbmo zzbmo2 = this;
            return googleApiClient2.zze((zzm)new zzbmp(zzbmo2, googleApiClient2, zzbkw2, zzbpy3));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PendingResult<Status> zzb(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        zzbq.checkArgument((boolean)zzj.zza(1, driveId));
        zzbq.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        zzbq.checkNotNull((Object)changeListener, (Object)"listener");
        Map<DriveId, Map<ChangeListener, zzbpy>> map = this.zzgnm;
        synchronized (map) {
            Map<ChangeListener, zzbpy> map2 = this.zzgnm.get((Object)driveId);
            if (map2 == null) {
                return new zzbmi(googleApiClient, Status.zzfni);
            }
            zzbpy zzbpy2 = map2.remove(changeListener);
            if (zzbpy2 == null) {
                return new zzbmi(googleApiClient, Status.zzfni);
            }
            if (map2.isEmpty()) {
                this.zzgnm.remove((Object)driveId);
            }
            zzbpy zzbpy3 = zzbpy2;
            zzbsg zzbsg2 = new zzbsg(driveId, 1);
            GoogleApiClient googleApiClient2 = googleApiClient;
            zzbmo zzbmo2 = this;
            return googleApiClient2.zze((zzm)new zzbmq(zzbmo2, googleApiClient2, zzbsg2, zzbpy3));
        }
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.drive.internal.IDriveService");
        if (iInterface instanceof zzbqi) {
            return (zzbqi)iInterface;
        }
        return new zzbqj(iBinder2);
    }
}

