/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.text.TextUtils;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.internal.zzbnq;
import java.util.Arrays;

public class ExecutionOptions {
    public static final int MAX_TRACKING_TAG_STRING_LENGTH = 65536;
    public static final int CONFLICT_STRATEGY_OVERWRITE_REMOTE = 0;
    public static final int CONFLICT_STRATEGY_KEEP_REMOTE = 1;
    private final String zza;
    private final boolean zzb;
    private final int zzc;

    @Hide
    public ExecutionOptions(String string, boolean bl, int n) {
        this.zza = string;
        this.zzb = bl;
        this.zzc = n;
    }

    @Hide
    public final String zza() {
        return this.zza;
    }

    @Hide
    public final boolean zzb() {
        return this.zzb;
    }

    @Hide
    public final int zzc() {
        return this.zzc;
    }

    @Hide
    public static boolean zza(int n) {
        switch (n) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    @Hide
    public final void zza(GoogleApiClient googleApiClient) {
        zzbnq zzbnq2 = (zzbnq)googleApiClient.zza(Drive.zza);
        this.zza(zzbnq2);
    }

    @Hide
    public final void zza(zzbnq zzbnq2) {
        if (this.zzb && !zzbnq2.zzl()) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to be notified on completion");
        }
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        if (object == this) {
            return true;
        }
        ExecutionOptions executionOptions = (ExecutionOptions)object;
        return zzbg.zza((Object)this.zza, (Object)executionOptions.zza) && this.zzc == executionOptions.zzc && this.zzb == executionOptions.zzb;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zza, this.zzc, this.zzb});
    }

    public static class Builder {
        @Hide
        protected String zza;
        @Hide
        protected boolean zzb;
        @Hide
        protected int zzc = 0;

        public Builder() {
        }

        public Builder setTrackingTag(String string) {
            String string2 = string;
            if (!(!TextUtils.isEmpty((CharSequence)string2) && string2.length() <= 65536)) {
                throw new IllegalArgumentException(String.format("trackingTag must not be null nor empty, and the length must be <= the maximum length (%s)", 65536));
            }
            this.zza = string;
            return this;
        }

        public Builder setNotifyOnCompletion(boolean bl) {
            this.zzb = bl;
            return this;
        }

        public Builder setConflictStrategy(int n) {
            boolean bl;
            switch (n) {
                case 0: 
                case 1: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (!bl) {
                throw new IllegalArgumentException(new StringBuilder(53).append("Unrecognized value for conflict strategy: ").append(n).toString());
            }
            this.zzc = n;
            return this;
        }

        @Hide
        protected final void zza() {
            if (this.zzc == 1 && !this.zzb) {
                throw new IllegalStateException("Cannot use CONFLICT_STRATEGY_KEEP_REMOTE without requesting completion notifications");
            }
        }

        public ExecutionOptions build() {
            this.zza();
            return new ExecutionOptions(this.zza, this.zzb, this.zzc);
        }
    }
}

