/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.drive.metadata.CustomPropertyKey;
import com.google.android.gms.drive.metadata.MetadataField;
import com.google.android.gms.drive.metadata.internal.AppVisibleCustomProperties;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzbuj;
import com.google.android.gms.internal.zzbuw;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public final class MetadataChangeSet {
    public static final int INDEXABLE_TEXT_SIZE_LIMIT_BYTES = 131072;
    public static final int CUSTOM_PROPERTY_SIZE_LIMIT_BYTES = 124;
    public static final int MAX_PUBLIC_PROPERTIES_PER_RESOURCE = 30;
    public static final int MAX_PRIVATE_PROPERTIES_PER_RESOURCE_PER_APP = 30;
    public static final int MAX_TOTAL_PROPERTIES_PER_RESOURCE = 100;
    @Hide
    public static final MetadataChangeSet zza = new MetadataChangeSet(MetadataBundle.zza());
    private final MetadataBundle zzb;

    @Hide
    public MetadataChangeSet(MetadataBundle metadataBundle) {
        this.zzb = metadataBundle.zzb();
    }

    public final Map<CustomPropertyKey, String> getCustomPropertyChangeMap() {
        AppVisibleCustomProperties appVisibleCustomProperties = this.zzb.zza(zzbuj.zzc);
        if (appVisibleCustomProperties == null) {
            return Collections.emptyMap();
        }
        return appVisibleCustomProperties.zza();
    }

    public final String getDescription() {
        return this.zzb.zza(zzbuj.zzd);
    }

    public final String getIndexableText() {
        return this.zzb.zza(zzbuj.zzj);
    }

    public final Date getLastViewedByMeDate() {
        return this.zzb.zza(zzbuw.zzb);
    }

    public final String getMimeType() {
        return this.zzb.zza(zzbuj.zzx);
    }

    public final String getTitle() {
        return this.zzb.zza(zzbuj.zzag);
    }

    public final Boolean isPinned() {
        return this.zzb.zza(zzbuj.zzp);
    }

    public final Boolean isStarred() {
        return this.zzb.zza(zzbuj.zzae);
    }

    public final Boolean isViewed() {
        return this.zzb.zza(zzbuj.zzw);
    }

    @Hide
    public final MetadataBundle zza() {
        return this.zzb;
    }

    @Hide
    public final <T> MetadataChangeSet zza(MetadataField<T> metadataField, T t) {
        MetadataChangeSet metadataChangeSet = this;
        MetadataChangeSet metadataChangeSet2 = new MetadataChangeSet(metadataChangeSet.zzb);
        metadataChangeSet2.zzb.zzb(metadataField, t);
        return metadataChangeSet2;
    }

    public static class Builder {
        private final MetadataBundle zza = MetadataBundle.zza();
        private AppVisibleCustomProperties.zza zzb;

        public Builder() {
        }

        private final AppVisibleCustomProperties.zza zza() {
            if (this.zzb == null) {
                this.zzb = new AppVisibleCustomProperties.zza();
            }
            return this.zzb;
        }

        private static int zza(String string) {
            if (string == null) {
                return 0;
            }
            return string.getBytes().length;
        }

        private static void zza(String string, int n, int n2) {
            int n3 = n2;
            int n4 = n;
            String string2 = string;
            zzbq.zzb((n2 <= n ? 1 : 0) != 0, (Object)String.format("%s must be no more than %d bytes, but is %d bytes.", string2, n4, n3));
        }

        public Builder setCustomProperty(CustomPropertyKey customPropertyKey, String string) {
            zzbq.zza((Object)((Object)customPropertyKey), (Object)"key");
            zzbq.zza((Object)string, (Object)"value");
            int n = Builder.zza(customPropertyKey.getKey()) + Builder.zza(string);
            Builder.zza("The total size of key string and value string of a custom property", 124, n);
            this.zza().zza(customPropertyKey, string);
            return this;
        }

        public Builder deleteCustomProperty(CustomPropertyKey customPropertyKey) {
            zzbq.zza((Object)((Object)customPropertyKey), (Object)"key");
            this.zza().zza(customPropertyKey, null);
            return this;
        }

        public Builder setDescription(String string) {
            this.zza.zzb(zzbuj.zzd, string);
            return this;
        }

        public Builder setIndexableText(String string) {
            int n = Builder.zza(string);
            Builder.zza("Indexable text size", 131072, n);
            this.zza.zzb(zzbuj.zzj, string);
            return this;
        }

        public Builder setLastViewedByMeDate(Date date) {
            this.zza.zzb(zzbuw.zzb, date);
            return this;
        }

        public Builder setMimeType(@NonNull String string) {
            zzbq.zza((Object)string);
            this.zza.zzb(zzbuj.zzx, string);
            return this;
        }

        public Builder setPinned(boolean bl) {
            this.zza.zzb(zzbuj.zzp, bl);
            return this;
        }

        public Builder setStarred(boolean bl) {
            this.zza.zzb(zzbuj.zzae, bl);
            return this;
        }

        public Builder setTitle(@NonNull String string) {
            zzbq.zza((Object)string, (Object)"Title cannot be null.");
            this.zza.zzb(zzbuj.zzag, string);
            return this;
        }

        @Deprecated
        public Builder setViewed(boolean bl) {
            if (bl) {
                this.zza.zzb(zzbuj.zzw, true);
            } else if (this.zza.zzc(zzbuj.zzw)) {
                this.zza.zzb(zzbuj.zzw);
            }
            return this;
        }

        public Builder setViewed() {
            this.zza.zzb(zzbuj.zzw, true);
            return this;
        }

        public MetadataChangeSet build() {
            if (this.zzb != null) {
                this.zza.zzb(zzbuj.zzc, this.zzb.zza());
            }
            return new MetadataChangeSet(this.zza);
        }
    }
}

