/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.drive.FileUploadPreferences;
import com.google.android.gms.drive.TransferPreferences;
import java.util.Arrays;

@Hide
public class TransferPreferencesBuilder {
    public static final TransferPreferences DEFAULT_PREFERENCES = new zza(1, true, 256);
    private int zza;
    private boolean zzb;
    private int zzc;

    public TransferPreferencesBuilder() {
        this(DEFAULT_PREFERENCES);
    }

    public TransferPreferencesBuilder(TransferPreferences transferPreferences) {
        this.zza = transferPreferences.getNetworkPreference();
        this.zzb = transferPreferences.isRoamingAllowed();
        this.zzc = transferPreferences.getBatteryUsagePreference();
    }

    @Hide
    public TransferPreferencesBuilder(FileUploadPreferences fileUploadPreferences) {
        this.zza = fileUploadPreferences.getNetworkTypePreference();
        this.zzb = fileUploadPreferences.isRoamingAllowed();
        this.zzc = fileUploadPreferences.getBatteryUsagePreference();
    }

    public TransferPreferencesBuilder setNetworkPreference(int n) {
        this.zza = n;
        return this;
    }

    public TransferPreferencesBuilder setIsRoamingAllowed(boolean bl) {
        this.zzb = bl;
        return this;
    }

    public TransferPreferencesBuilder setBatteryUsagePreference(int n) {
        this.zzc = n;
        return this;
    }

    public TransferPreferences build() {
        return new zza(this.zza, this.zzb, this.zzc);
    }

    static final class zza
    implements TransferPreferences {
        private final int zza;
        private final boolean zzb;
        private final int zzc;

        zza(int n, boolean bl, int n2) {
            this.zza = n;
            this.zzb = bl;
            this.zzc = n2;
        }

        @Override
        public final int getNetworkPreference() {
            return this.zza;
        }

        @Override
        public final boolean isRoamingAllowed() {
            return this.zzb;
        }

        @Override
        public final int getBatteryUsagePreference() {
            return this.zzc;
        }

        public final int hashCode() {
            return Arrays.hashCode(new Object[]{this.zza, this.zzb, this.zzc});
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            zza zza2 = (zza)object;
            return zza2.zza == this.zza && zza2.zzb == this.zzb && zza2.zzc == this.zzc;
        }

        public final String toString() {
            return String.format("NetworkPreference: %s, IsRoamingAllowed %s, BatteryUsagePreference %s", this.zza, this.zzb, this.zzc);
        }
    }
}

