/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzal;
import com.google.android.gms.common.util.zzz;
import com.google.android.gms.drive.events.ChangeEvent;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.CompletionEvent;
import com.google.android.gms.drive.events.CompletionListener;
import com.google.android.gms.drive.events.DriveEvent;
import com.google.android.gms.drive.events.zzd;
import com.google.android.gms.drive.events.zzh;
import com.google.android.gms.drive.events.zzi;
import com.google.android.gms.drive.events.zzv;
import com.google.android.gms.internal.zzbrp;
import com.google.android.gms.internal.zzbsf;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class DriveEventService
extends Service
implements ChangeListener,
CompletionListener,
zzd,
zzi {
    private static final zzal zzc = new zzal("DriveEventService", "");
    public static final String ACTION_HANDLE_EVENT = "com.google.android.gms.drive.events.HANDLE_EVENT";
    private final String zzd;
    private CountDownLatch zze;
    zza zza;
    boolean zzb = false;
    private int zzf = -1;

    protected DriveEventService(String string) {
        this.zzd = string;
    }

    protected DriveEventService() {
        this(DriveEventService.class.getSimpleName());
    }

    public final synchronized IBinder onBind(Intent intent) {
        if (ACTION_HANDLE_EVENT.equals(intent.getAction())) {
            if (this.zza == null && !this.zzb) {
                this.zzb = true;
                CountDownLatch countDownLatch = new CountDownLatch(1);
                this.zze = new CountDownLatch(1);
                new zzh(this, countDownLatch).start();
                try {
                    if (!countDownLatch.await(5000L, TimeUnit.MILLISECONDS)) {
                        zzc.zzc("DriveEventService", "Failed to synchronously initialize event handler.");
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException("Unable to start event handler", interruptedException);
                }
            }
            return new zzb(this).asBinder();
        }
        return null;
    }

    public boolean onUnbind(Intent intent) {
        return true;
    }

    public synchronized void onDestroy() {
        zzc.zza("DriveEventService", "onDestroy");
        if (this.zza != null) {
            Message message = this.zza.zza();
            this.zza.sendMessage(message);
            this.zza = null;
            try {
                if (!this.zze.await(5000L, TimeUnit.MILLISECONDS)) {
                    zzc.zzb("DriveEventService", "Failed to synchronously quit event handler. Will quit itself");
                }
            }
            catch (InterruptedException interruptedException) {}
            this.zze = null;
        }
        super.onDestroy();
    }

    @Override
    public void onChange(ChangeEvent changeEvent) {
        zzc.zzb("DriveEventService", "Unhandled change event in %s: %s", new Object[]{this.zzd, changeEvent});
    }

    @Override
    @Hide
    public final void zza(com.google.android.gms.drive.events.zzb zzb2) {
        zzc.zzb("DriveEventService", "Unhandled changes available event in %s: %s", new Object[]{this.zzd, zzb2});
    }

    @Override
    public void onCompletion(CompletionEvent completionEvent) {
        zzc.zzb("DriveEventService", "Unhandled completion event in %s: %s", new Object[]{this.zzd, completionEvent});
    }

    protected int getCallingUid() {
        return Binder.getCallingUid();
    }

    private final void zza(zzbsf zzbsf2) {
        DriveEvent driveEvent = zzbsf2.zza();
        zzc.zza("DriveEventService", "handleEventMessage: %s", new Object[]{driveEvent});
        try {
            switch (driveEvent.zza()) {
                case 1: {
                    this.onChange((ChangeEvent)driveEvent);
                    return;
                }
                case 2: {
                    this.onCompletion((CompletionEvent)driveEvent);
                    return;
                }
                case 4: {
                    this.zza((com.google.android.gms.drive.events.zzb)driveEvent);
                    return;
                }
                case 7: {
                    zzv zzv2 = (zzv)driveEvent;
                    DriveEventService driveEventService = this;
                    zzc.zzb("DriveEventService", "Unhandled transfer state event in %s: %s", new Object[]{driveEventService.zzd, zzv2});
                    return;
                }
            }
            zzc.zzb("DriveEventService", "Unhandled event: %s", new Object[]{driveEvent});
            return;
        }
        catch (Exception exception) {
            zzc.zzc("DriveEventService", String.format("Error handling event in %s", this.zzd), (Throwable)exception);
            return;
        }
    }

    private final void zzb() throws SecurityException {
        int n = this.getCallingUid();
        if (n == this.zzf) {
            return;
        }
        if (zzz.zza((Context)this, (int)n)) {
            this.zzf = n;
            return;
        }
        throw new SecurityException("Caller is not GooglePlayServices");
    }

    static /* synthetic */ CountDownLatch zzb(DriveEventService driveEventService) {
        return driveEventService.zze;
    }

    @Hide
    final class zzb
    extends zzbrp {
        private /* synthetic */ DriveEventService zza;

        zzb(DriveEventService driveEventService) {
            this.zza = driveEventService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void zza(zzbsf zzbsf2) throws RemoteException {
            DriveEventService driveEventService = this.zza;
            synchronized (driveEventService) {
                zzc.zza("DriveEventService", "onEvent: %s", new Object[]{zzbsf2});
                this.zza.zzb();
                if (this.zza.zza != null) {
                    Message message = this.zza.zza.zza(zzbsf2);
                    this.zza.zza.sendMessage(message);
                } else {
                    zzc.zzc("DriveEventService", "Receiving event before initialize is completed.");
                }
                return;
            }
        }
    }

    @Hide
    final class zza
    extends Handler {
        private /* synthetic */ DriveEventService zza;

        zza(DriveEventService driveEventService) {
            this.zza = driveEventService;
        }

        private final Message zza(zzbsf zzbsf2) {
            return this.obtainMessage(1, (Object)zzbsf2);
        }

        private final Message zza() {
            return this.obtainMessage(2);
        }

        public final void handleMessage(Message message) {
            zzc.zza("DriveEventService", "handleMessage message type: %s", new Object[]{message.what});
            switch (message.what) {
                case 1: {
                    this.zza.zza((zzbsf)((Object)message.obj));
                    return;
                }
                case 2: {
                    this.getLooper().quit();
                    return;
                }
            }
            zzc.zzb("DriveEventService", "Unexpected message type: %s", new Object[]{message.what});
        }
    }
}

