/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.metadata;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.drive.metadata.zzc;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class CustomPropertyKey
extends zzbgl {
    public static final Parcelable.Creator<CustomPropertyKey> CREATOR = new zzc();
    public static final int PUBLIC = 0;
    public static final int PRIVATE = 1;
    private String zza;
    private int zzb;
    private static final Pattern zzc = Pattern.compile("[\\w.!@$%^&*()/-]+");

    public CustomPropertyKey(String string, int n) {
        zzbq.zza((Object)string, (Object)"key");
        zzbq.zzb((boolean)zzc.matcher(string).matches(), (Object)"key name characters must be alphanumeric or one of .!@$%^&*()-_/");
        zzbq.zzb((n == 0 || n == 1 ? 1 : 0) != 0, (Object)"visibility must be either PUBLIC or PRIVATE");
        this.zza = string;
        this.zzb = n;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CustomPropertyKey customPropertyKey = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)customPropertyKey.zza, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (int)customPropertyKey.zzb);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public String getKey() {
        return this.zza;
    }

    public int getVisibility() {
        return this.zzb;
    }

    public int hashCode() {
        String string = this.zza;
        int n = this.zzb;
        return new StringBuilder(11 + String.valueOf(string).length()).append(string).append(n).toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        CustomPropertyKey customPropertyKey = (CustomPropertyKey)((Object)object);
        return customPropertyKey.getKey().equals(this.zza) && customPropertyKey.getVisibility() == this.zzb;
    }

    public String toString() {
        String string = this.zza;
        int n = this.zzb;
        return new StringBuilder(31 + String.valueOf(string).length()).append("CustomPropertyKey(").append(string).append(",").append(n).append(")").toString();
    }

    public JSONObject toJson() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("key", (Object)this.getKey());
        jSONObject.put("visibility", this.getVisibility());
        return jSONObject;
    }

    public static CustomPropertyKey fromJson(JSONObject jSONObject) throws JSONException {
        return new CustomPropertyKey(jSONObject.getString("key"), jSONObject.getInt("visibility"));
    }
}

