/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.metadata.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzal;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.drive.metadata.MetadataField;
import com.google.android.gms.drive.metadata.internal.zzf;
import com.google.android.gms.drive.metadata.internal.zzj;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbuj;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

@Hide
public final class MetadataBundle
extends zzbgl
implements ReflectedParcelable {
    private static final zzal zza = new zzal("MetadataBundle", "");
    public static final Parcelable.Creator<MetadataBundle> CREATOR = new zzj();
    private Bundle zzb;

    @Hide
    MetadataBundle(Bundle bundle) {
        this.zzb = (Bundle)zzbq.zza((Object)bundle);
        this.zzb.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.zzb.keySet()) {
            if (zzf.zza(string) != null) continue;
            arrayList.add(string);
            zza.zzb("MetadataBundle", "Ignored unknown metadata field in bundle: %s", new Object[]{string});
        }
        ArrayList<String> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            String string;
            Object e = arrayList2.get(i);
            string = (String)e;
            this.zzb.remove(string);
        }
    }

    public static MetadataBundle zza() {
        return new MetadataBundle(new Bundle());
    }

    public static <T> MetadataBundle zza(MetadataField<T> metadataField, T t) {
        MetadataBundle metadataBundle = MetadataBundle.zza();
        metadataBundle.zzb(metadataField, t);
        return metadataBundle;
    }

    public final MetadataBundle zzb() {
        return new MetadataBundle(new Bundle(this.zzb));
    }

    public final <T> void zzb(MetadataField<T> metadataField, T t) {
        if (zzf.zza(metadataField.zza()) == null) {
            String string = String.valueOf(metadataField.zza());
            throw new IllegalArgumentException(string.length() != 0 ? "Unregistered field: ".concat(string) : new String("Unregistered field: "));
        }
        metadataField.zza(t, this.zzb);
    }

    public final <T> T zza(MetadataField<T> metadataField) {
        return metadataField.zza(this.zzb);
    }

    public final <T> T zzb(MetadataField<T> metadataField) {
        T t = this.zza(metadataField);
        this.zzb.remove(metadataField.zza());
        return t;
    }

    public final boolean zzc(MetadataField<?> metadataField) {
        return this.zzb.containsKey(metadataField.zza());
    }

    public final Set<MetadataField<?>> zzc() {
        HashSet hashSet = new HashSet();
        for (String string : this.zzb.keySet()) {
            hashSet.add(zzf.zza(string));
        }
        return hashSet;
    }

    public final void zza(Context context) {
        BitmapTeleporter bitmapTeleporter = this.zza(zzbuj.zzaf);
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zza(context.getCacheDir());
        }
    }

    public final int hashCode() {
        int n = 1;
        for (String string : this.zzb.keySet()) {
            n = n * 31 + this.zzb.get(string).hashCode();
        }
        return n;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        MetadataBundle metadataBundle = (MetadataBundle)((Object)object);
        Set set = this.zzb.keySet();
        if (!set.equals(metadataBundle.zzb.keySet())) {
            return false;
        }
        for (String string : set) {
            if (zzbg.zza((Object)this.zzb.get(string), (Object)metadataBundle.zzb.get(string))) continue;
            return false;
        }
        return true;
    }

    public final String toString() {
        String string = String.valueOf(this.zzb);
        return new StringBuilder(24 + String.valueOf(string).length()).append("MetadataBundle [values=").append(string).append("]").toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        MetadataBundle metadataBundle = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (Bundle)metadataBundle.zzb, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }
}

