/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.util.zzz;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.zzd;
import com.google.android.gms.drive.events.zzj;
import com.google.android.gms.drive.events.zzl;
import com.google.android.gms.internal.zzbly;
import com.google.android.gms.internal.zzbms;
import com.google.android.gms.internal.zzbnk;
import com.google.android.gms.internal.zzbnr;
import com.google.android.gms.internal.zzbns;
import com.google.android.gms.internal.zzbra;
import com.google.android.gms.internal.zzbrk;
import com.google.android.gms.internal.zzbrl;
import com.google.android.gms.internal.zzbti;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Hide
public final class zzbnq
extends zzab<zzbrk> {
    private final String zze;
    private final Bundle zzf;
    protected final boolean zzd;
    private volatile DriveId zzg;
    private volatile DriveId zzh;
    private volatile boolean zzi = false;
    private GoogleApiClient.ConnectionCallbacks zzj;
    private Map<DriveId, Map<ChangeListener, zzbra>> zzk = new HashMap<DriveId, Map<ChangeListener, zzbra>>();
    private Map<zzd, zzbra> zzl = new HashMap<zzd, zzbra>();
    private Map<DriveId, Map<zzl, zzbra>> zzm = new HashMap<DriveId, Map<zzl, zzbra>>();
    private Map<DriveId, Map<zzl, zzbra>> zzn = new HashMap<DriveId, Map<zzl, zzbra>>();

    public zzbnq(Context context, Looper looper, zzr zzr2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, Bundle bundle) {
        super(context, looper, 11, zzr2, connectionCallbacks, onConnectionFailedListener);
        this.zze = zzr2.zzh();
        this.zzj = connectionCallbacks;
        this.zzf = bundle;
        Intent intent = new Intent("com.google.android.gms.drive.events.HANDLE_EVENT");
        intent.setPackage(context.getPackageName());
        List list = context.getPackageManager().queryIntentServices(intent, 0);
        switch (list.size()) {
            case 0: {
                this.zzd = false;
                return;
            }
            case 1: {
                ServiceInfo serviceInfo = ((ResolveInfo)list.get((int)0)).serviceInfo;
                if (!serviceInfo.exported) {
                    String string = serviceInfo.name;
                    throw new IllegalStateException(new StringBuilder(60 + String.valueOf(string).length()).append("Drive event service ").append(string).append(" must be exported in AndroidManifest.xml").toString());
                }
                this.zzd = true;
                return;
            }
        }
        String string = intent.getAction();
        throw new IllegalStateException(new StringBuilder(72 + String.valueOf(string).length()).append("AndroidManifest.xml can only define one service that handles the ").append(string).append(" action").toString());
    }

    public final boolean l_() {
        return !this.zzaa().getPackageName().equals(this.zze) || !zzz.zza((Context)this.zzaa(), (int)Process.myUid());
    }

    public final boolean zzag() {
        return true;
    }

    protected final String zzb() {
        return "com.google.android.gms.drive.internal.IDriveService";
    }

    protected final Bundle zzc() {
        String string = this.zzaa().getPackageName();
        zzbq.zza((Object)string);
        zzbq.zza((!this.zzai().zzf().isEmpty() ? 1 : 0) != 0);
        Bundle bundle = new Bundle();
        if (!string.equals(this.zze)) {
            bundle.putString("proxy_package_name", this.zze);
        }
        bundle.putAll(this.zzf);
        return bundle;
    }

    protected final String zza() {
        return "com.google.android.gms.drive.ApiService.START";
    }

    public final DriveId zzi() {
        return this.zzg;
    }

    public final DriveId zzj() {
        return this.zzh;
    }

    public final boolean zzk() {
        return this.zzi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzg() {
        if (this.zzs()) {
            try {
                ((zzbrk)this.zzaf()).zza(new zzbms());
            }
            catch (RemoteException remoteException) {}
        }
        super.zzg();
        Map<Object, Object> map = this.zzk;
        synchronized (map) {
            this.zzk.clear();
        }
        map = this.zzl;
        synchronized (map) {
            this.zzl.clear();
        }
        map = this.zzm;
        synchronized (map) {
            this.zzm.clear();
        }
        map = this.zzn;
        synchronized (map) {
            this.zzn.clear();
            return;
        }
    }

    protected final void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (bundle != null) {
            bundle.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.zzg = (DriveId)bundle.getParcelable("com.google.android.gms.drive.root_id");
            this.zzh = (DriveId)bundle.getParcelable("com.google.android.gms.drive.appdata_id");
            this.zzi = true;
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public final boolean zzl() {
        return this.zzd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        zzbq.zzb((boolean)com.google.android.gms.drive.events.zzj.zza(1, driveId));
        zzbq.zza((Object)changeListener, (Object)"listener");
        zzbq.zza((boolean)this.zzs(), (Object)"Client must be connected");
        Map<DriveId, Map<ChangeListener, zzbra>> map = this.zzk;
        synchronized (map) {
            zzbra zzbra2;
            Map<ChangeListener, zzbra> map2 = this.zzk.get((Object)driveId);
            if (map2 == null) {
                map2 = new HashMap<ChangeListener, zzbra>();
                this.zzk.put(driveId, map2);
            }
            if ((zzbra2 = map2.get(changeListener)) == null) {
                zzbra2 = new zzbra(this.zzab(), this.zzaa(), 1, changeListener);
                map2.put(changeListener, zzbra2);
            } else if (zzbra2.zzb(1)) {
                return new zzbnk(googleApiClient, Status.zza);
            }
            zzbra2.zza(1);
            zzbra zzbra3 = zzbra2;
            zzbly zzbly2 = new zzbly(1, driveId);
            GoogleApiClient googleApiClient2 = googleApiClient;
            zzbnq zzbnq2 = this;
            return googleApiClient2.zzb((zzm)new zzbnr(zzbnq2, googleApiClient2, zzbly2, zzbra3));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PendingResult<Status> zzb(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        zzbq.zzb((boolean)com.google.android.gms.drive.events.zzj.zza(1, driveId));
        zzbq.zza((boolean)this.zzs(), (Object)"Client must be connected");
        zzbq.zza((Object)changeListener, (Object)"listener");
        Map<DriveId, Map<ChangeListener, zzbra>> map = this.zzk;
        synchronized (map) {
            Map<ChangeListener, zzbra> map2 = this.zzk.get((Object)driveId);
            if (map2 == null) {
                return new zzbnk(googleApiClient, Status.zza);
            }
            zzbra zzbra2 = map2.remove(changeListener);
            if (zzbra2 == null) {
                return new zzbnk(googleApiClient, Status.zza);
            }
            if (map2.isEmpty()) {
                this.zzk.remove((Object)driveId);
            }
            zzbra zzbra3 = zzbra2;
            zzbti zzbti2 = new zzbti(driveId, 1);
            GoogleApiClient googleApiClient2 = googleApiClient;
            zzbnq zzbnq2 = this;
            return googleApiClient2.zzb((zzm)new zzbns(zzbnq2, googleApiClient2, zzbti2, zzbra3));
        }
    }

    protected final /* synthetic */ IInterface zza(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.drive.internal.IDriveService");
        if (iInterface instanceof zzbrk) {
            return (zzbrk)iInterface;
        }
        return new zzbrl(iBinder2);
    }
}

