/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.internal.zzci;
import com.google.android.gms.common.api.internal.zzck;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbj;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.DriveResourceClient;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.Metadata;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ListenerToken;
import com.google.android.gms.drive.events.OnChangeListener;
import com.google.android.gms.drive.events.OpenFileCallback;
import com.google.android.gms.drive.events.zzj;
import com.google.android.gms.drive.query.Query;
import com.google.android.gms.drive.zzr;
import com.google.android.gms.drive.zzt;
import com.google.android.gms.internal.zzblv;
import com.google.android.gms.internal.zzbmu;
import com.google.android.gms.internal.zzbok;
import com.google.android.gms.internal.zzbpa;
import com.google.android.gms.internal.zzbpb;
import com.google.android.gms.internal.zzbpc;
import com.google.android.gms.internal.zzbpd;
import com.google.android.gms.internal.zzbpe;
import com.google.android.gms.internal.zzbpf;
import com.google.android.gms.internal.zzbpg;
import com.google.android.gms.internal.zzbph;
import com.google.android.gms.internal.zzbpi;
import com.google.android.gms.internal.zzbpj;
import com.google.android.gms.internal.zzbpk;
import com.google.android.gms.internal.zzbpl;
import com.google.android.gms.internal.zzbpm;
import com.google.android.gms.internal.zzbpn;
import com.google.android.gms.internal.zzbpo;
import com.google.android.gms.internal.zzbpp;
import com.google.android.gms.internal.zzbpq;
import com.google.android.gms.internal.zzbpr;
import com.google.android.gms.internal.zzbps;
import com.google.android.gms.internal.zzbpt;
import com.google.android.gms.internal.zzbpu;
import com.google.android.gms.internal.zzbpv;
import com.google.android.gms.internal.zzbpw;
import com.google.android.gms.internal.zzbpx;
import com.google.android.gms.internal.zzbpy;
import com.google.android.gms.internal.zzbpz;
import com.google.android.gms.internal.zzbqa;
import com.google.android.gms.internal.zzbqb;
import com.google.android.gms.internal.zzbqe;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

@Hide
public final class zzboz
extends DriveResourceClient {
    private final DriveApi zzb = new zzbmu();
    private static final AtomicInteger zzc = new AtomicInteger();

    public zzboz(@NonNull Context context, @Nullable Drive.zza zza2) {
        super(context, zza2);
    }

    public zzboz(@NonNull Activity activity, @Nullable Drive.zza zza2) {
        super(activity, zza2);
    }

    @Override
    public final Task<DriveFolder> getRootFolder() {
        return this.zza(new zzbpf(this));
    }

    @Override
    public final Task<DriveFolder> getAppFolder() {
        return this.zza(new zzbpq(this));
    }

    @Override
    public final Task<MetadataBuffer> query(@NonNull Query query) {
        return zzbj.zza(this.zzb.query(this.zze(), query), (zzbo)zzbpa.zza);
    }

    @Override
    public final Task<Metadata> getMetadata(@NonNull DriveResource driveResource) {
        zzbq.zza((Object)((Object)driveResource.getDriveId()));
        return this.zza(new zzbpx(this, driveResource));
    }

    @Override
    public final Task<Metadata> updateMetadata(@NonNull DriveResource driveResource, @NonNull MetadataChangeSet metadataChangeSet) {
        zzbq.zza((Object)((Object)driveResource.getDriveId()));
        zzbq.zza((Object)metadataChangeSet);
        return this.zzb(new zzbpy(this, metadataChangeSet, driveResource));
    }

    @Override
    public final Task<MetadataBuffer> listParents(@NonNull DriveResource driveResource) {
        zzbq.zza((Object)((Object)driveResource.getDriveId()));
        return this.zza(new zzbpz(this, driveResource));
    }

    @Override
    public final Task<Void> setParents(@NonNull DriveResource driveResource, @NonNull Set<DriveId> set) {
        zzbq.zza((Object)((Object)driveResource.getDriveId()));
        zzbq.zza(set);
        ArrayList<DriveId> arrayList = new ArrayList<DriveId>(set);
        return this.zzb(new zzbqa(this, driveResource, arrayList));
    }

    @Override
    public final Task<Void> delete(@NonNull DriveResource driveResource) {
        zzbq.zza((Object)((Object)driveResource.getDriveId()));
        return this.zzb(new zzbqb(this, driveResource));
    }

    @Override
    public final Task<Void> trash(@NonNull DriveResource driveResource) {
        zzbq.zza((Object)((Object)driveResource.getDriveId()));
        return this.zzb(new zzbpg(this, driveResource));
    }

    @Override
    public final Task<Void> untrash(@NonNull DriveResource driveResource) {
        zzbq.zza((Object)((Object)driveResource.getDriveId()));
        return this.zzb(new zzbph(this, driveResource));
    }

    @Override
    public final Task<ListenerToken> addChangeListener(@NonNull DriveResource driveResource, @NonNull OnChangeListener onChangeListener) {
        zzbq.zza((Object)((Object)driveResource.getDriveId()));
        zzbq.zza((Object)onChangeListener, (Object)"listener");
        zzbqe zzbqe2 = new zzbqe(this, onChangeListener, driveResource.getDriveId());
        int n = zzc.incrementAndGet();
        zzci zzci2 = this.zza(zzbqe2, new StringBuilder(27).append("OnChangeListener").append(n).toString());
        zzbpi zzbpi2 = new zzbpi(this, zzci2, driveResource, zzbqe2);
        zzbpj zzbpj2 = new zzbpj(this, zzci2.zzc(), driveResource, zzbqe2);
        return this.zza(zzbpi2, zzbpj2).continueWith((Continuation)new zzbpb(zzci2));
    }

    @Override
    public final Task<Boolean> removeChangeListener(@NonNull ListenerToken listenerToken) {
        zzbq.zza((Object)listenerToken, (Object)"Token is required to unregister listener.");
        if (listenerToken instanceof zzblv) {
            return this.zza(((zzblv)listenerToken).zza());
        }
        throw new IllegalStateException("Could not recover key from ListenerToken");
    }

    @Override
    public final Task<Void> addChangeSubscription(@NonNull DriveResource driveResource) {
        zzbq.zza((Object)((Object)driveResource.getDriveId()));
        zzbq.zzb((boolean)zzj.zza(1, driveResource.getDriveId()));
        return this.zzb(new zzbpk(this, driveResource));
    }

    @Override
    public final Task<Void> removeChangeSubscription(@NonNull DriveResource driveResource) {
        zzbq.zza((Object)((Object)driveResource.getDriveId()));
        zzbq.zzb((boolean)zzj.zza(1, driveResource.getDriveId()));
        return this.zzb(new zzbpl(this, driveResource));
    }

    @Override
    public final Task<DriveContents> openFile(@NonNull DriveFile driveFile, int n) {
        zzboz.zza(n);
        return this.zza(new zzbpm(this, driveFile, n));
    }

    @Override
    public final Task<ListenerToken> openFile(@NonNull DriveFile driveFile, int n, @NonNull OpenFileCallback openFileCallback) {
        zzboz.zza(n);
        int n2 = zzc.incrementAndGet();
        zzci zzci2 = this.zza(openFileCallback, new StringBuilder(27).append("OpenFileCallback").append(n2).toString());
        zzck zzck2 = zzci2.zzc();
        zzblv zzblv2 = new zzblv(zzck2);
        zzbpn zzbpn2 = new zzbpn(this, zzci2, driveFile, n, zzblv2, zzci2);
        zzbpo zzbpo2 = new zzbpo(this, zzck2, zzblv2);
        return this.zza(zzbpn2, zzbpo2).continueWith((Continuation)new zzbpc(zzblv2));
    }

    @Override
    public final Task<Boolean> cancelOpenFileCallback(@NonNull ListenerToken listenerToken) {
        if (!(listenerToken instanceof zzblv)) {
            throw new IllegalArgumentException("Unrecognized ListenerToken");
        }
        return this.zza(((zzblv)listenerToken).zza());
    }

    @Override
    public final Task<DriveContents> createContents() {
        return this.zzb(new zzbpp(this));
    }

    @Override
    public final Task<DriveContents> reopenContentsForWrite(@NonNull DriveContents driveContents) {
        zzbq.zzb((!driveContents.zzc() ? 1 : 0) != 0, (Object)"DriveContents is already closed");
        zzbq.zzb((driveContents.getMode() == 0x10000000 ? 1 : 0) != 0, (Object)"This method can only be called on contents that are currently opened in MODE_READ_ONLY.");
        driveContents.zzb();
        return this.zza(new zzbpr(this, driveContents));
    }

    @Override
    public final Task<Void> commitContents(@NonNull DriveContents driveContents, @Nullable MetadataChangeSet metadataChangeSet) {
        return ((DriveResourceClient)this).commitContents(driveContents, metadataChangeSet, (zzr)((ExecutionOptions.Builder)new zzt()).build());
    }

    @Override
    public final Task<Void> commitContents(@NonNull DriveContents driveContents, @Nullable MetadataChangeSet metadataChangeSet, @NonNull ExecutionOptions executionOptions) {
        zzbq.zza((Object)executionOptions, (Object)"Execution options cannot be null.");
        zzbq.zzb((!driveContents.zzc() ? 1 : 0) != 0, (Object)"DriveContents is already closed");
        zzbq.zzb((driveContents.getMode() != 0x10000000 ? 1 : 0) != 0, (Object)"Cannot commit contents opened in MODE_READ_ONLY.");
        zzbq.zza((Object)((Object)driveContents.getDriveId()), (Object)"Only DriveContents obtained through DriveFile.open can be committed.");
        zzr zzr2 = zzr.zza(executionOptions);
        if (ExecutionOptions.zza(zzr2.zzc()) && !driveContents.zza().zzg()) {
            throw new IllegalStateException("DriveContents must be valid for conflict detection.");
        }
        MetadataChangeSet metadataChangeSet2 = metadataChangeSet == null ? MetadataChangeSet.zza : metadataChangeSet;
        return this.zzb(new zzbps(this, zzr2, driveContents, metadataChangeSet2));
    }

    @Override
    public final Task<Void> discardContents(@NonNull DriveContents driveContents) {
        zzbq.zzb((!driveContents.zzc() ? 1 : 0) != 0, (Object)"DriveContents is already closed");
        driveContents.zzb();
        return this.zzb(new zzbpt(this, driveContents));
    }

    private static void zza(int n) {
        if (n != 0x10000000 && n != 0x20000000 && n != 0x30000000) {
            throw new IllegalArgumentException("Invalid openMode provided");
        }
    }

    @Override
    public final Task<MetadataBuffer> listChildren(@NonNull DriveFolder driveFolder) {
        return zzbj.zza(this.zzb.query(this.zze(), zzbok.zza(null, driveFolder.getDriveId())), (zzbo)zzbpd.zza);
    }

    @Override
    public final Task<MetadataBuffer> queryChildren(@NonNull DriveFolder driveFolder, @NonNull Query query) {
        return zzbj.zza(this.zzb.query(this.zze(), zzbok.zza(query, driveFolder.getDriveId())), (zzbo)zzbpe.zza);
    }

    @Override
    public final Task<DriveFile> createFile(@NonNull DriveFolder driveFolder, @NonNull MetadataChangeSet metadataChangeSet, @Nullable DriveContents driveContents) {
        return this.zzb(new zzbpu(this, metadataChangeSet, driveContents, driveFolder));
    }

    @Override
    public final Task<DriveFile> createFile(@NonNull DriveFolder driveFolder, @NonNull MetadataChangeSet metadataChangeSet, @Nullable DriveContents driveContents, @NonNull ExecutionOptions executionOptions) {
        zzbq.zza((Object)executionOptions, (Object)"executionOptions cannot be null");
        return this.zzb(new zzbpv(this, metadataChangeSet, driveContents, driveFolder, executionOptions));
    }

    @Override
    public final Task<DriveFolder> createFolder(@NonNull DriveFolder driveFolder, @NonNull MetadataChangeSet metadataChangeSet) {
        zzbq.zza((Object)metadataChangeSet, (Object)"MetadataChangeSet must be provided.");
        if (metadataChangeSet.getMimeType() != null && !metadataChangeSet.getMimeType().equals("application/vnd.google-apps.folder")) {
            throw new IllegalArgumentException("The mimetype must be of type application/vnd.google-apps.folder");
        }
        return this.zzb(new zzbpw(this, metadataChangeSet, driveFolder));
    }

    static final /* synthetic */ ListenerToken zza(zzblv zzblv2, Task task) throws Exception {
        if (task.isSuccessful()) {
            return zzblv2;
        }
        throw task.getException();
    }

    static final /* synthetic */ ListenerToken zza(zzci zzci2, Task task) throws Exception {
        if (task.isSuccessful()) {
            return new zzblv(zzci2.zzc());
        }
        throw task.getException();
    }
}

