/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.zzj;
import com.google.android.gms.internal.zzbly;
import com.google.android.gms.internal.zzbnq;
import com.google.android.gms.internal.zzbnt;
import com.google.android.gms.internal.zzbnu;
import com.google.android.gms.internal.zzbqm;
import com.google.android.gms.internal.zzbqn;
import com.google.android.gms.internal.zzbqo;
import com.google.android.gms.internal.zzbqp;
import com.google.android.gms.internal.zzbqq;
import com.google.android.gms.internal.zzbqr;
import com.google.android.gms.internal.zzbqs;
import java.util.ArrayList;
import java.util.Set;

@Hide
public class zzbql
implements DriveResource {
    protected final DriveId zza;

    public zzbql(DriveId driveId) {
        this.zza = driveId;
    }

    @Override
    public DriveId getDriveId() {
        return this.zza;
    }

    @Override
    public PendingResult<DriveResource.MetadataResult> getMetadata(GoogleApiClient googleApiClient) {
        GoogleApiClient googleApiClient2 = googleApiClient;
        zzbql zzbql2 = this;
        return googleApiClient2.zza((zzm)new zzbqm(zzbql2, googleApiClient2, false));
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> listParents(GoogleApiClient googleApiClient) {
        return googleApiClient.zza((zzm)new zzbqn(this, googleApiClient));
    }

    @Override
    public PendingResult<Status> setParents(GoogleApiClient googleApiClient, Set<DriveId> set) {
        if (set == null) {
            throw new IllegalArgumentException("ParentIds must be provided.");
        }
        ArrayList<DriveId> arrayList = new ArrayList<DriveId>(set);
        return googleApiClient.zzb((zzm)new zzbqo(this, googleApiClient, arrayList));
    }

    @Override
    public PendingResult<DriveResource.MetadataResult> updateMetadata(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet) {
        if (metadataChangeSet == null) {
            throw new IllegalArgumentException("ChangeSet must be provided.");
        }
        return googleApiClient.zzb((zzm)new zzbqp(this, googleApiClient, metadataChangeSet));
    }

    @Override
    public PendingResult<Status> delete(GoogleApiClient googleApiClient) {
        return googleApiClient.zzb((zzm)new zzbqq(this, googleApiClient));
    }

    @Override
    public PendingResult<Status> addChangeListener(GoogleApiClient googleApiClient, ChangeListener changeListener) {
        return ((zzbnq)googleApiClient.zza(Drive.zza)).zza(googleApiClient, this.zza, changeListener);
    }

    @Override
    public PendingResult<Status> removeChangeListener(GoogleApiClient googleApiClient, ChangeListener changeListener) {
        return ((zzbnq)googleApiClient.zza(Drive.zza)).zzb(googleApiClient, this.zza, changeListener);
    }

    @Override
    public PendingResult<Status> addChangeSubscription(GoogleApiClient googleApiClient) {
        DriveId driveId = this.zza;
        GoogleApiClient googleApiClient2 = googleApiClient;
        zzbnq zzbnq2 = (zzbnq)googleApiClient.zza(Drive.zza);
        zzbly zzbly2 = new zzbly(1, driveId);
        GoogleApiClient googleApiClient3 = googleApiClient2;
        zzbnq zzbnq3 = zzbnq2;
        zzbq.zzb((boolean)zzj.zza(zzbly2.zzb, zzbly2.zza));
        zzbq.zza((boolean)zzbnq3.zzs(), (Object)"Client must be connected");
        if (!zzbnq3.zzd) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to add event subscriptions");
        }
        return googleApiClient3.zzb((zzm)new zzbnt(zzbnq3, googleApiClient3, zzbly2));
    }

    @Override
    public PendingResult<Status> removeChangeSubscription(GoogleApiClient googleApiClient) {
        DriveId driveId = this.zza;
        GoogleApiClient googleApiClient2 = googleApiClient;
        zzbnq zzbnq2 = (zzbnq)googleApiClient.zza(Drive.zza);
        DriveId driveId2 = driveId;
        GoogleApiClient googleApiClient3 = googleApiClient2;
        zzbnq zzbnq3 = zzbnq2;
        zzbq.zzb((boolean)zzj.zza(1, driveId2));
        zzbq.zza((boolean)zzbnq3.zzs(), (Object)"Client must be connected");
        return googleApiClient3.zzb((zzm)new zzbnu(zzbnq3, googleApiClient3, driveId2, 1));
    }

    @Override
    public PendingResult<Status> trash(GoogleApiClient googleApiClient) {
        return googleApiClient.zzb((zzm)new zzbqr(this, googleApiClient));
    }

    @Override
    public PendingResult<Status> untrash(GoogleApiClient googleApiClient) {
        return googleApiClient.zzb((zzm)new zzbqs(this, googleApiClient));
    }
}

