/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.drive.metadata.CustomPropertyKey;
import com.google.android.gms.drive.metadata.MetadataField;
import com.google.android.gms.drive.metadata.internal.AppVisibleCustomProperties;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzbuj;
import com.google.android.gms.internal.zzbuw;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public final class MetadataChangeSet {
    public static final int INDEXABLE_TEXT_SIZE_LIMIT_BYTES = 131072;
    public static final int CUSTOM_PROPERTY_SIZE_LIMIT_BYTES = 124;
    public static final int MAX_PUBLIC_PROPERTIES_PER_RESOURCE = 30;
    public static final int MAX_PRIVATE_PROPERTIES_PER_RESOURCE_PER_APP = 30;
    public static final int MAX_TOTAL_PROPERTIES_PER_RESOURCE = 100;
    @Hide
    public static final MetadataChangeSet zzgqo = new MetadataChangeSet(MetadataBundle.zzaqz());
    private final MetadataBundle zzgqp;

    @Hide
    public MetadataChangeSet(MetadataBundle metadataBundle) {
        this.zzgqp = metadataBundle.zzara();
    }

    public final Map<CustomPropertyKey, String> getCustomPropertyChangeMap() {
        AppVisibleCustomProperties appVisibleCustomProperties = this.zzgqp.zza(zzbuj.zzgyz);
        if (appVisibleCustomProperties == null) {
            return Collections.emptyMap();
        }
        return appVisibleCustomProperties.zzaqv();
    }

    public final String getDescription() {
        return this.zzgqp.zza(zzbuj.zzgza);
    }

    public final String getIndexableText() {
        return this.zzgqp.zza(zzbuj.zzgzg);
    }

    public final Date getLastViewedByMeDate() {
        return this.zzgqp.zza(zzbuw.zzhaq);
    }

    public final String getMimeType() {
        return this.zzgqp.zza(zzbuj.zzgzu);
    }

    public final String getTitle() {
        return this.zzgqp.zza(zzbuj.zzhad);
    }

    public final Boolean isPinned() {
        return this.zzgqp.zza(zzbuj.zzgzm);
    }

    public final Boolean isStarred() {
        return this.zzgqp.zza(zzbuj.zzhab);
    }

    public final Boolean isViewed() {
        return this.zzgqp.zza(zzbuj.zzgzt);
    }

    @Hide
    public final MetadataBundle zzapv() {
        return this.zzgqp;
    }

    @Hide
    public final <T> MetadataChangeSet zza(MetadataField<T> metadataField, T t) {
        MetadataChangeSet metadataChangeSet = this;
        MetadataChangeSet metadataChangeSet2 = new MetadataChangeSet(metadataChangeSet.zzgqp);
        metadataChangeSet2.zzgqp.zzc(metadataField, t);
        return metadataChangeSet2;
    }

    public static class Builder {
        private final MetadataBundle zzgqp = MetadataBundle.zzaqz();
        private AppVisibleCustomProperties.zza zzgqq;

        public Builder() {
        }

        private final AppVisibleCustomProperties.zza zzapw() {
            if (this.zzgqq == null) {
                this.zzgqq = new AppVisibleCustomProperties.zza();
            }
            return this.zzgqq;
        }

        private static int zzhf(String string) {
            if (string == null) {
                return 0;
            }
            return string.getBytes().length;
        }

        private static void zzi(String string, int n, int n2) {
            int n3 = n2;
            int n4 = n;
            String string2 = string;
            zzbq.checkArgument((n2 <= n ? 1 : 0) != 0, (Object)String.format("%s must be no more than %d bytes, but is %d bytes.", string2, n4, n3));
        }

        public Builder setCustomProperty(CustomPropertyKey customPropertyKey, String string) {
            zzbq.checkNotNull((Object)((Object)customPropertyKey), (Object)"key");
            zzbq.checkNotNull((Object)string, (Object)"value");
            int n = Builder.zzhf(customPropertyKey.getKey()) + Builder.zzhf(string);
            Builder.zzi("The total size of key string and value string of a custom property", 124, n);
            this.zzapw().zza(customPropertyKey, string);
            return this;
        }

        public Builder deleteCustomProperty(CustomPropertyKey customPropertyKey) {
            zzbq.checkNotNull((Object)((Object)customPropertyKey), (Object)"key");
            this.zzapw().zza(customPropertyKey, null);
            return this;
        }

        public Builder setDescription(String string) {
            this.zzgqp.zzc(zzbuj.zzgza, string);
            return this;
        }

        public Builder setIndexableText(String string) {
            int n = Builder.zzhf(string);
            Builder.zzi("Indexable text size", 131072, n);
            this.zzgqp.zzc(zzbuj.zzgzg, string);
            return this;
        }

        public Builder setLastViewedByMeDate(Date date) {
            this.zzgqp.zzc(zzbuw.zzhaq, date);
            return this;
        }

        public Builder setMimeType(@NonNull String string) {
            zzbq.checkNotNull((Object)string);
            this.zzgqp.zzc(zzbuj.zzgzu, string);
            return this;
        }

        public Builder setPinned(boolean bl) {
            this.zzgqp.zzc(zzbuj.zzgzm, bl);
            return this;
        }

        public Builder setStarred(boolean bl) {
            this.zzgqp.zzc(zzbuj.zzhab, bl);
            return this;
        }

        public Builder setTitle(@NonNull String string) {
            zzbq.checkNotNull((Object)string, (Object)"Title cannot be null.");
            this.zzgqp.zzc(zzbuj.zzhad, string);
            return this;
        }

        @Deprecated
        public Builder setViewed(boolean bl) {
            if (bl) {
                this.zzgqp.zzc(zzbuj.zzgzt, true);
            } else if (this.zzgqp.zzd(zzbuj.zzgzt)) {
                this.zzgqp.zzc(zzbuj.zzgzt);
            }
            return this;
        }

        public Builder setViewed() {
            this.zzgqp.zzc(zzbuj.zzgzt, true);
            return this;
        }

        public MetadataChangeSet build() {
            if (this.zzgqq != null) {
                this.zzgqp.zzc(zzbuj.zzgyz, this.zzgqq.zzaqw());
            }
            return new MetadataChangeSet(this.zzgqp);
        }
    }
}

