/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzal;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ResourceEvent;
import com.google.android.gms.drive.events.zzg;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbrr;
import com.google.android.gms.internal.zzbuj;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class CompletionEvent
extends zzbgl
implements ResourceEvent {
    private static final zzal zzgpv = new zzal("CompletionEvent", "");
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_FAILURE = 1;
    public static final int STATUS_CONFLICT = 2;
    public static final int STATUS_CANCELED = 3;
    public static final Parcelable.Creator<CompletionEvent> CREATOR = new zzg();
    private DriveId zzgpe;
    private String zzehk;
    private ParcelFileDescriptor zzgrs;
    private ParcelFileDescriptor zzgrt;
    private MetadataBundle zzgru;
    private List<String> zzgrv;
    private int zzcfl;
    private IBinder zzgrw;
    private boolean zzgrx = false;
    private boolean zzgry = false;
    private boolean zzgrz = false;

    @Hide
    CompletionEvent(DriveId driveId, String string, ParcelFileDescriptor parcelFileDescriptor, ParcelFileDescriptor parcelFileDescriptor2, MetadataBundle metadataBundle, List<String> list, int n, IBinder iBinder) {
        this.zzgpe = driveId;
        this.zzehk = string;
        this.zzgrs = parcelFileDescriptor;
        this.zzgrt = parcelFileDescriptor2;
        this.zzgru = metadataBundle;
        this.zzgrv = list;
        this.zzcfl = n;
        this.zzgrw = iBinder;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        int n2 = n | 1;
        Parcel parcel2 = parcel;
        CompletionEvent completionEvent = this;
        int n3 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (Parcelable)completionEvent.zzgpe, (int)n2, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (String)completionEvent.zzehk, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (Parcelable)completionEvent.zzgrs, (int)n2, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (Parcelable)completionEvent.zzgrt, (int)n2, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (Parcelable)completionEvent.zzgru, (int)n2, (boolean)false);
        zzbgo.zzb((Parcel)parcel2, (int)7, completionEvent.zzgrv, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)8, (int)completionEvent.zzcfl);
        zzbgo.zza((Parcel)parcel2, (int)9, (IBinder)completionEvent.zzgrw, (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n3);
    }

    @Override
    @Hide
    public final int getType() {
        return 2;
    }

    @Override
    public final DriveId getDriveId() {
        this.zzaqa();
        return this.zzgpe;
    }

    public final String getAccountName() {
        this.zzaqa();
        return this.zzehk;
    }

    public final InputStream getBaseContentsInputStream() {
        this.zzaqa();
        if (this.zzgrs == null) {
            return null;
        }
        if (this.zzgrx) {
            throw new IllegalStateException("getBaseInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzgrx = true;
        return new FileInputStream(this.zzgrs.getFileDescriptor());
    }

    public final InputStream getModifiedContentsInputStream() {
        this.zzaqa();
        if (this.zzgrt == null) {
            return null;
        }
        if (this.zzgry) {
            throw new IllegalStateException("getModifiedInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzgry = true;
        return new FileInputStream(this.zzgrt.getFileDescriptor());
    }

    public final MetadataChangeSet getModifiedMetadataChangeSet() {
        this.zzaqa();
        if (this.zzgru != null) {
            return new MetadataChangeSet(this.zzgru);
        }
        return null;
    }

    public final List<String> getTrackingTags() {
        this.zzaqa();
        return new ArrayList<String>(this.zzgrv);
    }

    public final int getStatus() {
        this.zzaqa();
        return this.zzcfl;
    }

    public final void dismiss() {
        this.zzaf(false);
    }

    public final void snooze() {
        this.zzaf(true);
    }

    private final void zzaf(boolean bl) {
        this.zzaqa();
        this.zzgrz = true;
        zzp.zza((ParcelFileDescriptor)this.zzgrs);
        zzp.zza((ParcelFileDescriptor)this.zzgrt);
        if (this.zzgru != null && this.zzgru.zzd(zzbuj.zzhac)) {
            this.zzgru.zza(zzbuj.zzhac).release();
        }
        if (this.zzgrw == null) {
            String string = bl ? "snooze" : "dismiss";
            zzgpv.zzd("CompletionEvent", "No callback on %s", new Object[]{string});
            return;
        }
        try {
            zzbrr.zzao(this.zzgrw).zzaf(bl);
            return;
        }
        catch (RemoteException remoteException) {
            String string = bl ? "snooze" : "dismiss";
            zzgpv.zzd("CompletionEvent", String.format("RemoteException on %s", string), (Throwable)remoteException);
            return;
        }
    }

    private final void zzaqa() {
        if (this.zzgrz) {
            throw new IllegalStateException("Event has already been dismissed or snoozed.");
        }
    }

    public final String toString() {
        String string;
        if (this.zzgrv == null) {
            string = "<null>";
        } else {
            String string2 = TextUtils.join((CharSequence)"','", this.zzgrv);
            string = new StringBuilder(2 + String.valueOf(string2).length()).append("'").append(string2).append("'").toString();
        }
        String string3 = string;
        return String.format(Locale.US, "CompletionEvent [id=%s, status=%s, trackingTag=%s]", new Object[]{this.zzgpe, this.zzcfl, string3});
    }
}

