/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.drive.metadata.CustomPropertyKey;
import com.google.android.gms.drive.metadata.internal.AppVisibleCustomProperties;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzii;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public final class MetadataChangeSet {
    public static final int INDEXABLE_TEXT_SIZE_LIMIT_BYTES = 131072;
    public static final int CUSTOM_PROPERTY_SIZE_LIMIT_BYTES = 124;
    public static final int MAX_PUBLIC_PROPERTIES_PER_RESOURCE = 30;
    public static final int MAX_PRIVATE_PROPERTIES_PER_RESOURCE_PER_APP = 30;
    public static final int MAX_TOTAL_PROPERTIES_PER_RESOURCE = 100;
    public static final MetadataChangeSet zzWk = new MetadataChangeSet(MetadataBundle.zzok());
    private final MetadataBundle zzWl;

    public MetadataChangeSet(MetadataBundle bag) {
        this.zzWl = MetadataBundle.zza(bag);
    }

    public Map<CustomPropertyKey, String> getCustomPropertyChangeMap() {
        AppVisibleCustomProperties appVisibleCustomProperties = this.zzWl.zza(zzig.zzZJ);
        return appVisibleCustomProperties == null ? Collections.emptyMap() : appVisibleCustomProperties.zzog();
    }

    public String getDescription() {
        return this.zzWl.zza(zzig.zzZK);
    }

    public String getIndexableText() {
        return this.zzWl.zza(zzig.zzZP);
    }

    public Date getLastViewedByMeDate() {
        return this.zzWl.zza(zzii.zzaav);
    }

    public String getMimeType() {
        return this.zzWl.zza(zzig.zzaac);
    }

    public String getTitle() {
        return this.zzWl.zza(zzig.zzaal);
    }

    public Boolean isPinned() {
        return this.zzWl.zza(zzig.zzZU);
    }

    public Boolean isStarred() {
        return this.zzWl.zza(zzig.zzaaj);
    }

    public Boolean isViewed() {
        return this.zzWl.zza(zzig.zzaab);
    }

    public MetadataBundle zznz() {
        return this.zzWl;
    }

    public static class Builder {
        private final MetadataBundle zzWl = MetadataBundle.zzok();
        private AppVisibleCustomProperties.zza zzWm;

        private AppVisibleCustomProperties.zza zznA() {
            if (this.zzWm == null) {
                this.zzWm = new AppVisibleCustomProperties.zza();
            }
            return this.zzWm;
        }

        private int zzcb(String string) {
            return string == null ? 0 : string.getBytes().length;
        }

        private String zzj(String string, int n, int n2) {
            return String.format("%s must be no more than %d bytes, but is %d bytes.", string, n, n2);
        }

        private void zzk(String string, int n, int n2) {
            zzv.zzb((n2 <= n ? 1 : 0) != 0, (Object)this.zzj(string, n, n2));
        }

        public Builder setCustomProperty(CustomPropertyKey key, String value) {
            zzv.zzb((Object)key, (Object)"key");
            zzv.zzb((Object)value, (Object)"value");
            int n = this.zzcb(key.getKey()) + this.zzcb(value);
            this.zzk("The total size of key string and value string of a custom property", 124, n);
            this.zznA().zza(key, value);
            return this;
        }

        public Builder deleteCustomProperty(CustomPropertyKey key) {
            zzv.zzb((Object)key, (Object)"key");
            this.zznA().zza(key, null);
            return this;
        }

        public Builder setDescription(String description) {
            this.zzWl.zzb(zzig.zzZK, description);
            return this;
        }

        public Builder setIndexableText(String text) {
            int n = this.zzcb(text);
            this.zzk("Indexable text size", 131072, n);
            this.zzWl.zzb(zzig.zzZP, text);
            return this;
        }

        public Builder setLastViewedByMeDate(Date date) {
            this.zzWl.zzb(zzii.zzaav, date);
            return this;
        }

        public Builder setMimeType(String mimeType) {
            this.zzWl.zzb(zzig.zzaac, mimeType);
            return this;
        }

        public Builder setPinned(boolean pinned) {
            this.zzWl.zzb(zzig.zzZU, pinned);
            return this;
        }

        public Builder setStarred(boolean starred) {
            this.zzWl.zzb(zzig.zzaaj, starred);
            return this;
        }

        public Builder setTitle(String title) {
            this.zzWl.zzb(zzig.zzaal, title);
            return this;
        }

        public Builder setViewed(boolean viewed) {
            this.zzWl.zzb(zzig.zzaab, viewed);
            return this;
        }

        public MetadataChangeSet build() {
            if (this.zzWm != null) {
                this.zzWl.zzb(zzig.zzZJ, this.zzWm.zzoh());
            }
            return new MetadataChangeSet(this.zzWl);
        }
    }
}

