/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ResourceEvent;
import com.google.android.gms.drive.events.zze;
import com.google.android.gms.drive.internal.zzan;
import com.google.android.gms.drive.internal.zzx;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzhy;
import com.google.android.gms.internal.zzig;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class CompletionEvent
implements SafeParcelable,
ResourceEvent {
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_FAILURE = 1;
    public static final int STATUS_CONFLICT = 2;
    public static final int STATUS_CANCELED = 3;
    public static final Parcelable.Creator<CompletionEvent> CREATOR = new zze();
    final int zzzH;
    final DriveId zzVL;
    final String zzKw;
    final ParcelFileDescriptor zzWQ;
    final ParcelFileDescriptor zzWR;
    final MetadataBundle zzWS;
    final List<String> zzWT;
    final int zzue;
    final IBinder zzWU;
    private boolean zzWV = false;
    private boolean zzWW = false;
    private boolean zzWX = false;

    CompletionEvent(int versionCode, DriveId driveId, String accountName, ParcelFileDescriptor baseParcelFileDescriptor, ParcelFileDescriptor modifiedParcelFileDescriptor, MetadataBundle modifiedMetadataBundle, List<String> trackingTags, int status, IBinder releaseCallback) {
        this.zzzH = versionCode;
        this.zzVL = driveId;
        this.zzKw = accountName;
        this.zzWQ = baseParcelFileDescriptor;
        this.zzWR = modifiedParcelFileDescriptor;
        this.zzWS = modifiedMetadataBundle;
        this.zzWT = trackingTags;
        this.zzue = status;
        this.zzWU = releaseCallback;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zze.zza(this, dest, flags);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public DriveId getDriveId() {
        this.zznH();
        return this.zzVL;
    }

    public String getAccountName() {
        this.zznH();
        return this.zzKw;
    }

    public InputStream getBaseContentsInputStream() {
        this.zznH();
        if (this.zzWQ == null) {
            return null;
        }
        if (this.zzWV) {
            throw new IllegalStateException("getBaseInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzWV = true;
        return new FileInputStream(this.zzWQ.getFileDescriptor());
    }

    public InputStream getModifiedContentsInputStream() {
        this.zznH();
        if (this.zzWR == null) {
            return null;
        }
        if (this.zzWW) {
            throw new IllegalStateException("getModifiedInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzWW = true;
        return new FileInputStream(this.zzWR.getFileDescriptor());
    }

    public MetadataChangeSet getModifiedMetadataChangeSet() {
        this.zznH();
        return this.zzWS != null ? new MetadataChangeSet(this.zzWS) : null;
    }

    public List<String> getTrackingTags() {
        this.zznH();
        return new ArrayList<String>(this.zzWT);
    }

    public int getStatus() {
        this.zznH();
        return this.zzue;
    }

    public void dismiss() {
        this.zzR(false);
    }

    public void snooze() {
        this.zzR(true);
    }

    private void zzR(boolean bl) {
        this.zznH();
        this.zzWX = true;
        zzhy.zza((ParcelFileDescriptor)this.zzWQ);
        zzhy.zza((ParcelFileDescriptor)this.zzWR);
        if (this.zzWS != null && this.zzWS.zzc(zzig.zzaak)) {
            this.zzWS.zza(zzig.zzaak).release();
        }
        if (this.zzWU == null) {
            zzx.zzu("CompletionEvent", "No callback on " + (bl ? "snooze" : "dismiss"));
            return;
        }
        try {
            zzan.zza.zzae(this.zzWU).zzR(bl);
        }
        catch (RemoteException remoteException) {
            zzx.zzu("CompletionEvent", "RemoteException on " + (bl ? "snooze" : "dismiss") + ": " + (Object)((Object)remoteException));
        }
    }

    private void zznH() {
        if (this.zzWX) {
            throw new IllegalStateException("Event has already been dismissed or snoozed.");
        }
    }

    public String toString() {
        String string = this.zzWT == null ? "<null>" : "'" + TextUtils.join((CharSequence)"','", this.zzWT) + "'";
        return String.format(Locale.US, "CompletionEvent [id=%s, status=%s, trackingTag=%s]", this.zzVL, this.zzue, string);
    }
}

