/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.drive.events.ChangeEvent;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.ChangesAvailableEvent;
import com.google.android.gms.drive.events.CompletionEvent;
import com.google.android.gms.drive.events.CompletionListener;
import com.google.android.gms.drive.events.DriveEvent;
import com.google.android.gms.drive.events.zzc;
import com.google.android.gms.drive.internal.OnEventResponse;
import com.google.android.gms.drive.internal.zzam;
import com.google.android.gms.drive.internal.zzx;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class DriveEventService
extends Service
implements ChangeListener,
CompletionListener,
zzc {
    public static final String ACTION_HANDLE_EVENT = "com.google.android.gms.drive.events.HANDLE_EVENT";
    private final String mName;
    private CountDownLatch zzWY;
    zza zzWZ;
    boolean zzXa = false;
    int zzSR = -1;

    protected DriveEventService(String name) {
        this.mName = name;
    }

    protected DriveEventService() {
        this("DriveEventService");
    }

    public final synchronized IBinder onBind(Intent intent) {
        if (ACTION_HANDLE_EVENT.equals(intent.getAction())) {
            if (this.zzWZ == null && !this.zzXa) {
                this.zzXa = true;
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                this.zzWY = new CountDownLatch(1);
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Looper.prepare();
                            DriveEventService.this.zzWZ = new zza();
                            DriveEventService.this.zzXa = false;
                            countDownLatch.countDown();
                            zzx.zzs("DriveEventService", "Bound and starting loop");
                            Looper.loop();
                            zzx.zzs("DriveEventService", "Finished loop");
                        }
                        finally {
                            if (DriveEventService.this.zzWY != null) {
                                DriveEventService.this.zzWY.countDown();
                            }
                        }
                    }
                }.start();
                try {
                    boolean bl = countDownLatch.await(5000L, TimeUnit.MILLISECONDS);
                    if (!bl) {
                        zzx.zzu("DriveEventService", "Failed to synchronously initialize event handler.");
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException("Unable to start event handler", interruptedException);
                }
            }
            return new zzb().asBinder();
        }
        return null;
    }

    public boolean onUnbind(Intent intent) {
        return true;
    }

    public synchronized void onDestroy() {
        zzx.zzs("DriveEventService", "onDestroy");
        if (this.zzWZ != null) {
            Message message = this.zzWZ.zznJ();
            this.zzWZ.sendMessage(message);
            this.zzWZ = null;
            try {
                boolean bl = this.zzWY.await(5000L, TimeUnit.MILLISECONDS);
                if (!bl) {
                    zzx.zzt("DriveEventService", "Failed to synchronously quit event handler. Will quit itself");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.zzWY = null;
        }
        super.onDestroy();
    }

    @Override
    public void onChange(ChangeEvent event) {
        zzx.zzt(this.mName, "Unhandled change event: " + event);
    }

    @Override
    public void zza(ChangesAvailableEvent changesAvailableEvent) {
        zzx.zzt(this.mName, "Unhandled changes available event: " + changesAvailableEvent);
    }

    @Override
    public void onCompletion(CompletionEvent event) {
        zzx.zzt(this.mName, "Unhandled completion event: " + event);
    }

    protected int getCallingUid() {
        return Binder.getCallingUid();
    }

    private void zza(OnEventResponse onEventResponse) {
        DriveEvent driveEvent = onEventResponse.zzob();
        zzx.zzs("DriveEventService", "handleEventMessage: " + driveEvent);
        try {
            switch (driveEvent.getType()) {
                case 1: {
                    this.onChange((ChangeEvent)driveEvent);
                    break;
                }
                case 2: {
                    this.onCompletion((CompletionEvent)driveEvent);
                    break;
                }
                case 4: {
                    this.zza((ChangesAvailableEvent)driveEvent);
                    break;
                }
                default: {
                    zzx.zzt(this.mName, "Unhandled event: " + driveEvent);
                    break;
                }
            }
        }
        catch (Exception exception) {
            zzx.zza(this.mName, exception, "Error handling event: " + driveEvent);
        }
    }

    private void zznI() throws SecurityException {
        int n = this.getCallingUid();
        if (n == this.zzSR) {
            return;
        }
        if (GooglePlayServicesUtil.zzd((Context)this, (int)n)) {
            this.zzSR = n;
            return;
        }
        throw new SecurityException("Caller is not GooglePlayServices");
    }

    final class zzb
    extends zzam.zza {
        zzb() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzc(OnEventResponse onEventResponse) throws RemoteException {
            DriveEventService driveEventService = DriveEventService.this;
            synchronized (driveEventService) {
                zzx.zzs("DriveEventService", "onEvent: " + onEventResponse);
                DriveEventService.this.zznI();
                if (DriveEventService.this.zzWZ != null) {
                    Message message = DriveEventService.this.zzWZ.zzb(onEventResponse);
                    DriveEventService.this.zzWZ.sendMessage(message);
                } else {
                    zzx.zzu("DriveEventService", "Receiving event before initialize is completed.");
                }
            }
        }
    }

    final class zza
    extends Handler {
        zza() {
        }

        private Message zzb(OnEventResponse onEventResponse) {
            return this.obtainMessage(1, onEventResponse);
        }

        private Message zznJ() {
            return this.obtainMessage(2);
        }

        public void handleMessage(Message msg) {
            zzx.zzs("DriveEventService", "handleMessage message type:" + msg.what);
            switch (msg.what) {
                case 1: {
                    DriveEventService.this.zza((OnEventResponse)msg.obj);
                    break;
                }
                case 2: {
                    this.getLooper().quit();
                    break;
                }
                default: {
                    zzx.zzt("DriveEventService", "Unexpected message type:" + msg.what);
                }
            }
        }
    }
}

