/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.drive.CreateFileActivityBuilder;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.OpenFileActivityBuilder;
import com.google.android.gms.drive.internal.CreateContentsRequest;
import com.google.android.gms.drive.internal.GetMetadataRequest;
import com.google.android.gms.drive.internal.OnContentsResponse;
import com.google.android.gms.drive.internal.OnDriveIdResponse;
import com.google.android.gms.drive.internal.OnListEntriesResponse;
import com.google.android.gms.drive.internal.OnMetadataResponse;
import com.google.android.gms.drive.internal.QueryRequest;
import com.google.android.gms.drive.internal.zzal;
import com.google.android.gms.drive.internal.zzbr;
import com.google.android.gms.drive.internal.zzn;
import com.google.android.gms.drive.internal.zzr;
import com.google.android.gms.drive.internal.zzs;
import com.google.android.gms.drive.internal.zzt;
import com.google.android.gms.drive.internal.zzu;
import com.google.android.gms.drive.internal.zzw;
import com.google.android.gms.drive.query.Query;
import java.util.List;

public class zzq
implements DriveApi {
    @Override
    public PendingResult<DriveApi.MetadataBufferResult> query(GoogleApiClient apiClient, final Query query) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be provided.");
        }
        return apiClient.zza((zza.zza)new zzg(apiClient){

            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zznO().zza(new QueryRequest(query), (zzal)new zzi((zza.zzb<DriveApi.MetadataBufferResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.DriveContentsResult> newDriveContents(GoogleApiClient apiClient) {
        return this.zza(apiClient, 0x20000000);
    }

    public PendingResult<DriveApi.DriveContentsResult> zza(GoogleApiClient googleApiClient, final int n) {
        return googleApiClient.zza((zza.zza)new zzb(googleApiClient){

            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zznO().zza(new CreateContentsRequest(n), (zzal)new zzh((zza.zzb<DriveApi.DriveContentsResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.DriveIdResult> fetchDriveId(GoogleApiClient apiClient, final String resourceId) {
        return apiClient.zza((zza.zza)new zze(apiClient){

            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zznO().zza(new GetMetadataRequest(DriveId.zzbZ(resourceId), false), (zzal)new zzc((zza.zzb<DriveApi.DriveIdResult>)this));
            }
        });
    }

    @Override
    public DriveFile getFile(GoogleApiClient apiClient, DriveId driveId) {
        if (driveId == null) {
            throw new IllegalArgumentException("Id must be provided.");
        }
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        return new zzu(driveId);
    }

    @Override
    public DriveFolder getFolder(GoogleApiClient apiClient, DriveId driveId) {
        if (driveId == null) {
            throw new IllegalArgumentException("Id must be provided.");
        }
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        return new zzw(driveId);
    }

    @Override
    public DriveFolder getRootFolder(GoogleApiClient apiClient) {
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        zzs zzs2 = (zzs)apiClient.zza(Drive.zzKh);
        return new zzw(zzs2.zznP());
    }

    @Override
    public DriveFolder getAppFolder(GoogleApiClient apiClient) {
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        zzs zzs2 = (zzs)apiClient.zza(Drive.zzKh);
        DriveId driveId = zzs2.zznQ();
        return driveId != null ? new zzw(driveId) : null;
    }

    @Override
    public PendingResult<Status> requestSync(GoogleApiClient apiClient) {
        return apiClient.zzb((zza.zza)new zzr.zza(apiClient){

            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zznO().zza(new zzbr((zza.zzb<Status>)this));
            }
        });
    }

    @Override
    public OpenFileActivityBuilder newOpenFileActivityBuilder() {
        return new OpenFileActivityBuilder();
    }

    @Override
    public CreateFileActivityBuilder newCreateFileActivityBuilder() {
        return new CreateFileActivityBuilder();
    }

    @Override
    public PendingResult<Status> cancelPendingActions(GoogleApiClient apiClient, List<String> trackingTags) {
        zzs zzs2 = (zzs)apiClient.zza(Drive.zzKh);
        return zzs2.cancelPendingActions(apiClient, trackingTags);
    }

    private static class zzi
    extends com.google.android.gms.drive.internal.zzd {
        private final zza.zzb<DriveApi.MetadataBufferResult> zzKq;

        public zzi(zza.zzb<DriveApi.MetadataBufferResult> zzb2) {
            this.zzKq = zzb2;
        }

        @Override
        public void zza(OnListEntriesResponse onListEntriesResponse) throws RemoteException {
            MetadataBuffer metadataBuffer = new MetadataBuffer(onListEntriesResponse.zzoc());
            this.zzKq.zzj((Object)new zzf(Status.zzQU, metadataBuffer, onListEntriesResponse.zzod()));
        }

        @Override
        public void zzm(Status status) throws RemoteException {
            this.zzKq.zzj((Object)new zzf(status, null, false));
        }
    }

    static class zzf
    implements DriveApi.MetadataBufferResult {
        private final Status zzKr;
        private final MetadataBuffer zzXG;
        private final boolean zzXH;

        public zzf(Status status, MetadataBuffer metadataBuffer, boolean bl) {
            this.zzKr = status;
            this.zzXG = metadataBuffer;
            this.zzXH = bl;
        }

        public Status getStatus() {
            return this.zzKr;
        }

        @Override
        public MetadataBuffer getMetadataBuffer() {
            return this.zzXG;
        }

        public void release() {
            if (this.zzXG != null) {
                this.zzXG.release();
            }
        }
    }

    static abstract class zzg
    extends zzr<DriveApi.MetadataBufferResult> {
        zzg(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.MetadataBufferResult zzp(Status status) {
            return new zzf(status, null, false);
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzp(x0);
        }
    }

    static class zzc
    extends com.google.android.gms.drive.internal.zzd {
        private final zza.zzb<DriveApi.DriveIdResult> zzKq;

        public zzc(zza.zzb<DriveApi.DriveIdResult> zzb2) {
            this.zzKq = zzb2;
        }

        @Override
        public void zza(OnMetadataResponse onMetadataResponse) throws RemoteException {
            this.zzKq.zzj((Object)new zzd(Status.zzQU, new zzn(onMetadataResponse.zzof()).getDriveId()));
        }

        @Override
        public void zza(OnDriveIdResponse onDriveIdResponse) throws RemoteException {
            this.zzKq.zzj((Object)new zzd(Status.zzQU, onDriveIdResponse.getDriveId()));
        }

        @Override
        public void zzm(Status status) throws RemoteException {
            this.zzKq.zzj((Object)new zzd(status, null));
        }
    }

    private static class zzd
    implements DriveApi.DriveIdResult {
        private final Status zzKr;
        private final DriveId zzVL;

        public zzd(Status status, DriveId driveId) {
            this.zzKr = status;
            this.zzVL = driveId;
        }

        public Status getStatus() {
            return this.zzKr;
        }

        @Override
        public DriveId getDriveId() {
            return this.zzVL;
        }
    }

    static abstract class zze
    extends zzr<DriveApi.DriveIdResult> {
        zze(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.DriveIdResult zzo(Status status) {
            return new zzd(status, null);
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzo(x0);
        }
    }

    private static class zzh
    extends com.google.android.gms.drive.internal.zzd {
        private final zza.zzb<DriveApi.DriveContentsResult> zzKq;

        public zzh(zza.zzb<DriveApi.DriveContentsResult> zzb2) {
            this.zzKq = zzb2;
        }

        @Override
        public void zza(OnContentsResponse onContentsResponse) throws RemoteException {
            this.zzKq.zzj((Object)new zza(Status.zzQU, new zzt(onContentsResponse.zznW())));
        }

        @Override
        public void zzm(Status status) throws RemoteException {
            this.zzKq.zzj((Object)new zza(status, null));
        }
    }

    static class zza
    implements DriveApi.DriveContentsResult {
        private final Status zzKr;
        private final DriveContents zzVO;

        public zza(Status status, DriveContents driveContents) {
            this.zzKr = status;
            this.zzVO = driveContents;
        }

        public Status getStatus() {
            return this.zzKr;
        }

        @Override
        public DriveContents getDriveContents() {
            return this.zzVO;
        }
    }

    static abstract class zzb
    extends zzr<DriveApi.DriveContentsResult> {
        zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.DriveContentsResult zzn(Status status) {
            return new zza(status, null);
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzn(x0);
        }
    }

    static class zzj
    extends zzr.zza {
        zzj(GoogleApiClient googleApiClient, Status status) {
            super(googleApiClient);
            this.setResult((Result)status);
        }

        protected void zza(zzs zzs2) {
        }
    }
}

