/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.metadata.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.internal.zzy;
import com.google.android.gms.drive.metadata.MetadataField;
import com.google.android.gms.drive.metadata.internal.zze;
import com.google.android.gms.drive.metadata.internal.zzh;
import com.google.android.gms.internal.zzmb;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public final class MetadataBundle
implements SafeParcelable {
    public static final Parcelable.Creator<MetadataBundle> CREATOR = new zzh();
    final int mVersionCode;
    final Bundle zzakm;

    MetadataBundle(int versionCode, Bundle valueBundle) {
        this.mVersionCode = versionCode;
        this.zzakm = (Bundle)zzx.zzv((Object)valueBundle);
        this.zzakm.setClassLoader(this.getClass().getClassLoader());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.zzakm.keySet()) {
            if (zze.zzcG(string) != null) continue;
            arrayList.add(string);
            zzy.zzw("MetadataBundle", "Ignored unknown metadata field in bundle: " + string);
        }
        for (String string : arrayList) {
            this.zzakm.remove(string);
        }
    }

    private MetadataBundle(Bundle valueBundle) {
        this(1, valueBundle);
    }

    public static MetadataBundle zzrb() {
        return new MetadataBundle(new Bundle());
    }

    public static MetadataBundle zza(MetadataBundle metadataBundle) {
        return new MetadataBundle(new Bundle(metadataBundle.zzakm));
    }

    public static <T> MetadataBundle zza(MetadataField<T> metadataField, T t) {
        MetadataBundle metadataBundle = MetadataBundle.zzrb();
        metadataBundle.zzb(metadataField, t);
        return metadataBundle;
    }

    public <T> void zzb(MetadataField<T> metadataField, T t) {
        if (zze.zzcG(metadataField.getName()) == null) {
            throw new IllegalArgumentException("Unregistered field: " + metadataField.getName());
        }
        metadataField.zza(t, this.zzakm);
    }

    public <T> T zza(MetadataField<T> metadataField) {
        return metadataField.zzj(this.zzakm);
    }

    public boolean zzc(MetadataField<?> metadataField) {
        return this.zzakm.containsKey(metadataField.getName());
    }

    public Set<MetadataField<?>> zzrc() {
        HashSet hashSet = new HashSet();
        for (String string : this.zzakm.keySet()) {
            hashSet.add(zze.zzcG(string));
        }
        return hashSet;
    }

    public void setContext(Context context) {
        BitmapTeleporter bitmapTeleporter = this.zza(zzmb.zzakT);
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzc(context.getCacheDir());
        }
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        for (String string : this.zzakm.keySet()) {
            n2 = n2 * 31 + this.zzakm.get(string).hashCode();
        }
        return n2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetadataBundle)) {
            return false;
        }
        MetadataBundle metadataBundle = (MetadataBundle)obj;
        Set set = this.zzakm.keySet();
        if (!set.equals(metadataBundle.zzakm.keySet())) {
            return false;
        }
        for (String string : set) {
            if (zzw.equal((Object)this.zzakm.get(string), (Object)metadataBundle.zzakm.get(string))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "MetadataBundle [values=" + this.zzakm + "]";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzh.zza(this, dest, flags);
    }
}

