/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.drive.events.ChangeEvent;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.ChangesAvailableEvent;
import com.google.android.gms.drive.events.CompletionEvent;
import com.google.android.gms.drive.events.CompletionListener;
import com.google.android.gms.drive.events.DriveEvent;
import com.google.android.gms.drive.events.zzc;
import com.google.android.gms.drive.internal.OnEventResponse;
import com.google.android.gms.drive.internal.zzan;
import com.google.android.gms.drive.internal.zzy;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class DriveEventService
extends Service
implements ChangeListener,
CompletionListener,
zzc {
    public static final String ACTION_HANDLE_EVENT = "com.google.android.gms.drive.events.HANDLE_EVENT";
    private final String mName;
    private CountDownLatch zzahA;
    zza zzahB;
    boolean zzahC = false;
    int zzacB = -1;

    protected DriveEventService(String name) {
        this.mName = name;
    }

    protected DriveEventService() {
        this("DriveEventService");
    }

    public final synchronized IBinder onBind(Intent intent) {
        if (ACTION_HANDLE_EVENT.equals(intent.getAction())) {
            if (this.zzahB == null && !this.zzahC) {
                this.zzahC = true;
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                this.zzahA = new CountDownLatch(1);
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Looper.prepare();
                            DriveEventService.this.zzahB = new zza();
                            DriveEventService.this.zzahC = false;
                            countDownLatch.countDown();
                            zzy.zzv("DriveEventService", "Bound and starting loop");
                            Looper.loop();
                            zzy.zzv("DriveEventService", "Finished loop");
                        }
                        finally {
                            if (DriveEventService.this.zzahA != null) {
                                DriveEventService.this.zzahA.countDown();
                            }
                        }
                    }
                }.start();
                try {
                    boolean bl = countDownLatch.await(5000L, TimeUnit.MILLISECONDS);
                    if (!bl) {
                        zzy.zzx("DriveEventService", "Failed to synchronously initialize event handler.");
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException("Unable to start event handler", interruptedException);
                }
            }
            return new zzb().asBinder();
        }
        return null;
    }

    public boolean onUnbind(Intent intent) {
        return true;
    }

    public synchronized void onDestroy() {
        zzy.zzv("DriveEventService", "onDestroy");
        if (this.zzahB != null) {
            Message message = this.zzahB.zzqz();
            this.zzahB.sendMessage(message);
            this.zzahB = null;
            try {
                boolean bl = this.zzahA.await(5000L, TimeUnit.MILLISECONDS);
                if (!bl) {
                    zzy.zzw("DriveEventService", "Failed to synchronously quit event handler. Will quit itself");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.zzahA = null;
        }
        super.onDestroy();
    }

    @Override
    public void onChange(ChangeEvent event) {
        zzy.zzw(this.mName, "Unhandled change event: " + event);
    }

    @Override
    public void zza(ChangesAvailableEvent changesAvailableEvent) {
        zzy.zzw(this.mName, "Unhandled changes available event: " + changesAvailableEvent);
    }

    @Override
    public void onCompletion(CompletionEvent event) {
        zzy.zzw(this.mName, "Unhandled completion event: " + event);
    }

    protected int getCallingUid() {
        return Binder.getCallingUid();
    }

    private void zza(OnEventResponse onEventResponse) {
        DriveEvent driveEvent = onEventResponse.zzqS();
        zzy.zzv("DriveEventService", "handleEventMessage: " + driveEvent);
        try {
            switch (driveEvent.getType()) {
                case 1: {
                    this.onChange((ChangeEvent)driveEvent);
                    break;
                }
                case 2: {
                    this.onCompletion((CompletionEvent)driveEvent);
                    break;
                }
                case 4: {
                    this.zza((ChangesAvailableEvent)driveEvent);
                    break;
                }
                default: {
                    zzy.zzw(this.mName, "Unhandled event: " + driveEvent);
                    break;
                }
            }
        }
        catch (Exception exception) {
            zzy.zza(this.mName, exception, "Error handling event: " + driveEvent);
        }
    }

    private void zzqy() throws SecurityException {
        int n = this.getCallingUid();
        if (n == this.zzacB) {
            return;
        }
        if (GooglePlayServicesUtil.zze((Context)this, (int)n)) {
            this.zzacB = n;
            return;
        }
        throw new SecurityException("Caller is not GooglePlayServices");
    }

    final class zzb
    extends zzan.zza {
        zzb() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzc(OnEventResponse onEventResponse) throws RemoteException {
            DriveEventService driveEventService = DriveEventService.this;
            synchronized (driveEventService) {
                zzy.zzv("DriveEventService", "onEvent: " + onEventResponse);
                DriveEventService.this.zzqy();
                if (DriveEventService.this.zzahB != null) {
                    Message message = DriveEventService.this.zzahB.zzb(onEventResponse);
                    DriveEventService.this.zzahB.sendMessage(message);
                } else {
                    zzy.zzx("DriveEventService", "Receiving event before initialize is completed.");
                }
            }
        }
    }

    final class zza
    extends Handler {
        zza() {
        }

        private Message zzb(OnEventResponse onEventResponse) {
            return this.obtainMessage(1, onEventResponse);
        }

        private Message zzqz() {
            return this.obtainMessage(2);
        }

        public void handleMessage(Message msg) {
            zzy.zzv("DriveEventService", "handleMessage message type:" + msg.what);
            switch (msg.what) {
                case 1: {
                    DriveEventService.this.zza((OnEventResponse)msg.obj);
                    break;
                }
                case 2: {
                    this.getLooper().quit();
                    break;
                }
                default: {
                    zzy.zzw("DriveEventService", "Unexpected message type:" + msg.what);
                }
            }
        }
    }
}

