/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.content.IntentSender;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.internal.zzl;
import com.google.android.gms.drive.internal.zzv;

public class CreateFileActivityBuilder {
    public static final String EXTRA_RESPONSE_DRIVE_ID = "response_drive_id";
    private final zzl zzamH = new zzl(0);
    private DriveContents zzamI;
    private boolean zzamJ;

    public CreateFileActivityBuilder setInitialDriveContents(DriveContents driveContents) {
        if (driveContents != null) {
            if (!(driveContents instanceof zzv)) {
                throw new IllegalArgumentException("Only DriveContents obtained from the Drive API are accepted.");
            }
            if (driveContents.getDriveId() != null) {
                throw new IllegalArgumentException("Only DriveContents obtained through DriveApi.newDriveContents are accepted for file creation.");
            }
            if (driveContents.zzsj()) {
                throw new IllegalArgumentException("DriveContents are already closed.");
            }
            this.zzamH.zzcW(driveContents.zzsh().getRequestId());
            this.zzamI = driveContents;
        } else {
            this.zzamH.zzcW(1);
        }
        this.zzamJ = true;
        return this;
    }

    public CreateFileActivityBuilder setInitialMetadata(MetadataChangeSet metadataChangeSet) {
        this.zzamH.zza(metadataChangeSet);
        return this;
    }

    public CreateFileActivityBuilder setActivityStartFolder(DriveId folder) {
        this.zzamH.zza(folder);
        return this;
    }

    public CreateFileActivityBuilder setActivityTitle(String title) {
        this.zzamH.zzcT(title);
        return this;
    }

    public IntentSender build(GoogleApiClient apiClient) {
        zzx.zzb((Object)this.zzamJ, (Object)"Must call setInitialDriveContents to CreateFileActivityBuilder.");
        zzx.zza((boolean)apiClient.isConnected(), (Object)"Client must be connected");
        if (this.zzamI != null) {
            this.zzamI.zzsi();
        }
        return this.zzamH.build(apiClient);
    }
}

