/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.internal.zzab;
import com.google.android.gms.drive.internal.zzat;
import com.google.android.gms.drive.internal.zzau;
import com.google.android.gms.drive.internal.zzw;
import com.google.android.gms.drive.internal.zzy;
import com.google.android.gms.drive.internal.zzz;
import com.google.android.gms.drive.zze;
import com.google.android.gms.internal.zztj;
import com.google.android.gms.internal.zztk;

public class DriveId
implements SafeParcelable {
    public static final int RESOURCE_TYPE_UNKNOWN = -1;
    public static final int RESOURCE_TYPE_FILE = 0;
    public static final int RESOURCE_TYPE_FOLDER = 1;
    public static final Parcelable.Creator<DriveId> CREATOR = new zze();
    final int mVersionCode;
    final String zzamR;
    final long zzamS;
    final long zzamA;
    final int zzamT;
    private volatile String zzamC = null;
    private volatile String zzamU = null;

    public static DriveId zzcQ(String string) {
        zzx.zzy((Object)string);
        return new DriveId(string, -1L, -1L, -1);
    }

    public String getResourceId() {
        return this.zzamR;
    }

    public int getResourceType() {
        return this.zzamT;
    }

    public DriveFile asDriveFile() {
        if (this.zzamT == 1) {
            throw new IllegalStateException("This DriveId corresponds to a folder. Call asDriveFolder instead.");
        }
        return new zzw(this);
    }

    public DriveFolder asDriveFolder() {
        if (this.zzamT == 0) {
            throw new IllegalStateException("This DriveId corresponds to a file. Call asDriveFile instead.");
        }
        return new zzy(this);
    }

    public DriveResource asDriveResource() {
        if (this.zzamT == 1) {
            return this.asDriveFolder();
        }
        if (this.zzamT == 0) {
            return this.asDriveFile();
        }
        return new zzab(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zze.zza(this, out, flags);
    }

    DriveId(int versionCode, String resourceId, long sqlId, long databaseInstanceId, int resourceType) {
        this.mVersionCode = versionCode;
        this.zzamR = resourceId;
        zzx.zzab((!"".equals(resourceId) ? 1 : 0) != 0);
        zzx.zzab((resourceId != null || sqlId != -1L ? 1 : 0) != 0);
        this.zzamS = sqlId;
        this.zzamA = databaseInstanceId;
        this.zzamT = resourceType;
    }

    public DriveId(String resourceId, long sqlId, long databaseInstanceId, int resourceType) {
        this(1, resourceId, sqlId, databaseInstanceId, resourceType);
    }

    public int hashCode() {
        if (this.zzamS == -1L) {
            return this.zzamR.hashCode();
        }
        return (String.valueOf(this.zzamA) + String.valueOf(this.zzamS)).hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DriveId)) {
            return false;
        }
        DriveId driveId = (DriveId)obj;
        if (driveId.zzamA != this.zzamA) {
            return false;
        }
        if (driveId.zzamS == -1L && this.zzamS == -1L) {
            return driveId.zzamR.equals(this.zzamR);
        }
        if (this.zzamR == null || driveId.zzamR == null) {
            return driveId.zzamS == this.zzamS;
        }
        if (driveId.zzamS == this.zzamS) {
            if (driveId.zzamR.equals(this.zzamR)) {
                return true;
            }
            zzz.zzA("DriveId", "Unexpected unequal resourceId for same DriveId object.");
        }
        return false;
    }

    public final String encodeToString() {
        if (this.zzamC == null) {
            byte[] byArray = this.zzse();
            String string = Base64.encodeToString((byte[])byArray, (int)10);
            this.zzamC = "DriveId:" + string;
        }
        return this.zzamC;
    }

    public final String toInvariantString() {
        if (this.zzamU == null) {
            byte[] byArray = this.zzsk();
            this.zzamU = Base64.encodeToString((byte[])byArray, (int)10);
        }
        return this.zzamU;
    }

    final byte[] zzse() {
        zzat zzat2 = new zzat();
        zzat2.versionCode = this.mVersionCode;
        zzat2.zzapV = this.zzamR == null ? "" : this.zzamR;
        zzat2.zzapW = this.zzamS;
        zzat2.zzapT = this.zzamA;
        zzat2.zzapX = this.zzamT;
        byte[] byArray = zztk.toByteArray((zztk)zzat2);
        return byArray;
    }

    private byte[] zzsk() {
        zzau zzau2 = new zzau();
        zzau2.zzapW = this.zzamS;
        zzau2.zzapT = this.zzamA;
        byte[] byArray = zztk.toByteArray((zztk)zzau2);
        return byArray;
    }

    public String toString() {
        return this.encodeToString();
    }

    public static DriveId decodeFromString(String s) {
        zzx.zzb((boolean)s.startsWith("DriveId:"), (Object)("Invalid DriveId: " + s));
        String string = s.substring("DriveId:".length());
        byte[] byArray = Base64.decode((String)string, (int)10);
        return DriveId.zzl(byArray);
    }

    static DriveId zzl(byte[] byArray) {
        zzat zzat2;
        try {
            zzat2 = zzat.zzm(byArray);
        }
        catch (zztj zztj2) {
            throw new IllegalArgumentException();
        }
        String string = "".equals(zzat2.zzapV) ? null : zzat2.zzapV;
        DriveId driveId = new DriveId(zzat2.versionCode, string, zzat2.zzapW, zzat2.zzapT, zzat2.zzapX);
        return driveId;
    }
}

