/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.metadata.CustomPropertyKey;
import com.google.android.gms.drive.metadata.internal.AppVisibleCustomProperties;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzof;
import com.google.android.gms.internal.zzoh;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public final class MetadataChangeSet {
    public static final int INDEXABLE_TEXT_SIZE_LIMIT_BYTES = 131072;
    public static final int CUSTOM_PROPERTY_SIZE_LIMIT_BYTES = 124;
    public static final int MAX_PUBLIC_PROPERTIES_PER_RESOURCE = 30;
    public static final int MAX_PRIVATE_PROPERTIES_PER_RESOURCE_PER_APP = 30;
    public static final int MAX_TOTAL_PROPERTIES_PER_RESOURCE = 100;
    public static final MetadataChangeSet zzanh = new MetadataChangeSet(MetadataBundle.zztf());
    private final MetadataBundle zzani;

    public MetadataChangeSet(MetadataBundle bag) {
        this.zzani = MetadataBundle.zza(bag);
    }

    public Map<CustomPropertyKey, String> getCustomPropertyChangeMap() {
        AppVisibleCustomProperties appVisibleCustomProperties = this.zzani.zza(zzof.zzaqQ);
        return appVisibleCustomProperties == null ? Collections.emptyMap() : appVisibleCustomProperties.zzta();
    }

    public String getDescription() {
        return this.zzani.zza(zzof.zzaqR);
    }

    public String getIndexableText() {
        return this.zzani.zza(zzof.zzaqX);
    }

    public Date getLastViewedByMeDate() {
        return this.zzani.zza(zzoh.zzarH);
    }

    public String getMimeType() {
        return this.zzani.zza(zzof.zzarl);
    }

    public String getTitle() {
        return this.zzani.zza(zzof.zzaru);
    }

    public Boolean isPinned() {
        return this.zzani.zza(zzof.zzard);
    }

    public Boolean isStarred() {
        return this.zzani.zza(zzof.zzars);
    }

    public Boolean isViewed() {
        return this.zzani.zza(zzof.zzark);
    }

    public MetadataBundle zzsp() {
        return this.zzani;
    }

    public static class Builder {
        private final MetadataBundle zzani = MetadataBundle.zztf();
        private AppVisibleCustomProperties.zza zzanj;

        private AppVisibleCustomProperties.zza zzsq() {
            if (this.zzanj == null) {
                this.zzanj = new AppVisibleCustomProperties.zza();
            }
            return this.zzanj;
        }

        private int zzcS(String string) {
            return string == null ? 0 : string.getBytes().length;
        }

        private String zzj(String string, int n, int n2) {
            return String.format("%s must be no more than %d bytes, but is %d bytes.", string, n, n2);
        }

        private void zzk(String string, int n, int n2) {
            zzx.zzb((n2 <= n ? 1 : 0) != 0, (Object)this.zzj(string, n, n2));
        }

        public Builder setCustomProperty(CustomPropertyKey key, String value) {
            zzx.zzb((Object)key, (Object)"key");
            zzx.zzb((Object)value, (Object)"value");
            int n = this.zzcS(key.getKey()) + this.zzcS(value);
            this.zzk("The total size of key string and value string of a custom property", 124, n);
            this.zzsq().zza(key, value);
            return this;
        }

        public Builder deleteCustomProperty(CustomPropertyKey key) {
            zzx.zzb((Object)key, (Object)"key");
            this.zzsq().zza(key, null);
            return this;
        }

        public Builder setDescription(String description) {
            this.zzani.zzb(zzof.zzaqR, description);
            return this;
        }

        public Builder setIndexableText(String text) {
            int n = this.zzcS(text);
            this.zzk("Indexable text size", 131072, n);
            this.zzani.zzb(zzof.zzaqX, text);
            return this;
        }

        public Builder setLastViewedByMeDate(Date date) {
            this.zzani.zzb(zzoh.zzarH, date);
            return this;
        }

        public Builder setMimeType(String mimeType) {
            this.zzani.zzb(zzof.zzarl, mimeType);
            return this;
        }

        public Builder setPinned(boolean pinned) {
            this.zzani.zzb(zzof.zzard, pinned);
            return this;
        }

        public Builder setStarred(boolean starred) {
            this.zzani.zzb(zzof.zzars, starred);
            return this;
        }

        public Builder setTitle(String title) {
            this.zzani.zzb(zzof.zzaru, title);
            return this;
        }

        public Builder setViewed(boolean viewed) {
            this.zzani.zzb(zzof.zzark, viewed);
            return this;
        }

        public MetadataChangeSet build() {
            if (this.zzanj != null) {
                this.zzani.zzb(zzof.zzaqQ, this.zzanj.zztb());
            }
            return new MetadataChangeSet(this.zzani);
        }
    }
}

