/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.content.IntentSender;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.internal.OpenFileIntentSenderRequest;
import com.google.android.gms.drive.internal.zzam;
import com.google.android.gms.drive.internal.zzu;
import com.google.android.gms.drive.query.Filter;
import com.google.android.gms.drive.query.internal.FilterHolder;
import com.google.android.gms.drive.query.internal.zzg;

public class OpenFileActivityBuilder {
    public static final String EXTRA_RESPONSE_DRIVE_ID = "response_drive_id";
    private String zzank;
    private String[] zzanl;
    private Filter zzanm;
    private DriveId zzann;

    public OpenFileActivityBuilder setActivityTitle(String title) {
        this.zzank = (String)zzx.zzy((Object)title);
        return this;
    }

    public OpenFileActivityBuilder setMimeType(String[] mimeTypes) {
        zzx.zzb((mimeTypes != null ? 1 : 0) != 0, (Object)"mimeTypes may not be null");
        this.zzanl = mimeTypes;
        return this;
    }

    public OpenFileActivityBuilder setSelectionFilter(Filter filter) {
        zzx.zzb((filter != null ? 1 : 0) != 0, (Object)"filter may not be null");
        zzx.zzb((!zzg.zza(filter) ? 1 : 0) != 0, (Object)"FullTextSearchFilter cannot be used as a selection filter");
        this.zzanm = filter;
        return this;
    }

    public OpenFileActivityBuilder setActivityStartFolder(DriveId folder) {
        this.zzann = (DriveId)zzx.zzy((Object)folder);
        return this;
    }

    public IntentSender build(GoogleApiClient apiClient) {
        zzx.zza((boolean)apiClient.isConnected(), (Object)"Client must be connected");
        if (this.zzanl == null) {
            this.zzanl = new String[0];
        }
        if (this.zzanl.length > 0 && this.zzanm != null) {
            throw new IllegalStateException("Cannot use a selection filter and set mimetypes simultaneously");
        }
        FilterHolder filterHolder = this.zzanm == null ? null : new FilterHolder(this.zzanm);
        try {
            zzam zzam2 = ((zzu)apiClient.zza(Drive.zzTo)).zzsF();
            return zzam2.zza(new OpenFileIntentSenderRequest(this.zzank, this.zzanl, this.zzann, filterHolder));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Unable to connect Drive Play Service", remoteException);
        }
    }
}

