/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ResourceEvent;
import com.google.android.gms.drive.events.zze;
import com.google.android.gms.drive.internal.zzap;
import com.google.android.gms.drive.internal.zzz;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.internal.zzof;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class CompletionEvent
implements SafeParcelable,
ResourceEvent {
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_FAILURE = 1;
    public static final int STATUS_CONFLICT = 2;
    public static final int STATUS_CANCELED = 3;
    public static final Parcelable.Creator<CompletionEvent> CREATOR = new zze();
    final int mVersionCode;
    final DriveId zzamF;
    final String zzTD;
    final ParcelFileDescriptor zzanH;
    final ParcelFileDescriptor zzanI;
    final MetadataBundle zzanJ;
    final List<String> zzanK;
    final int zzAk;
    final IBinder zzanL;
    private boolean zzanM = false;
    private boolean zzanN = false;
    private boolean zzanO = false;

    CompletionEvent(int versionCode, DriveId driveId, String accountName, ParcelFileDescriptor baseParcelFileDescriptor, ParcelFileDescriptor modifiedParcelFileDescriptor, MetadataBundle modifiedMetadataBundle, List<String> trackingTags, int status, IBinder releaseCallback) {
        this.mVersionCode = versionCode;
        this.zzamF = driveId;
        this.zzTD = accountName;
        this.zzanH = baseParcelFileDescriptor;
        this.zzanI = modifiedParcelFileDescriptor;
        this.zzanJ = modifiedMetadataBundle;
        this.zzanK = trackingTags;
        this.zzAk = status;
        this.zzanL = releaseCallback;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zze.zza(this, dest, flags | 1);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public DriveId getDriveId() {
        this.zzsx();
        return this.zzamF;
    }

    public String getAccountName() {
        this.zzsx();
        return this.zzTD;
    }

    public InputStream getBaseContentsInputStream() {
        this.zzsx();
        if (this.zzanH == null) {
            return null;
        }
        if (this.zzanM) {
            throw new IllegalStateException("getBaseInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzanM = true;
        return new FileInputStream(this.zzanH.getFileDescriptor());
    }

    public InputStream getModifiedContentsInputStream() {
        this.zzsx();
        if (this.zzanI == null) {
            return null;
        }
        if (this.zzanN) {
            throw new IllegalStateException("getModifiedInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzanN = true;
        return new FileInputStream(this.zzanI.getFileDescriptor());
    }

    public MetadataChangeSet getModifiedMetadataChangeSet() {
        this.zzsx();
        return this.zzanJ != null ? new MetadataChangeSet(this.zzanJ) : null;
    }

    public List<String> getTrackingTags() {
        this.zzsx();
        return new ArrayList<String>(this.zzanK);
    }

    public int getStatus() {
        this.zzsx();
        return this.zzAk;
    }

    public void dismiss() {
        this.zzv(false);
    }

    public void snooze() {
        this.zzv(true);
    }

    private void zzv(boolean bl) {
        this.zzsx();
        this.zzanO = true;
        zznt.zza((ParcelFileDescriptor)this.zzanH);
        zznt.zza((ParcelFileDescriptor)this.zzanI);
        if (this.zzanJ != null && this.zzanJ.zzc(zzof.zzart)) {
            this.zzanJ.zza(zzof.zzart).release();
        }
        if (this.zzanL == null) {
            zzz.zzB("CompletionEvent", "No callback on " + (bl ? "snooze" : "dismiss"));
            return;
        }
        try {
            zzap.zza.zzbd(this.zzanL).zzv(bl);
        }
        catch (RemoteException remoteException) {
            zzz.zzB("CompletionEvent", "RemoteException on " + (bl ? "snooze" : "dismiss") + ": " + (Object)((Object)remoteException));
        }
    }

    private void zzsx() {
        if (this.zzanO) {
            throw new IllegalStateException("Event has already been dismissed or snoozed.");
        }
    }

    public String toString() {
        String string = this.zzanK == null ? "<null>" : "'" + TextUtils.join((CharSequence)"','", this.zzanK) + "'";
        return String.format(Locale.US, "CompletionEvent [id=%s, status=%s, trackingTag=%s]", this.zzamF, this.zzAk, string);
    }
}

