/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.Metadata;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.internal.DeleteResourceRequest;
import com.google.android.gms.drive.internal.GetMetadataRequest;
import com.google.android.gms.drive.internal.ListParentsRequest;
import com.google.android.gms.drive.internal.OnListParentsResponse;
import com.google.android.gms.drive.internal.OnMetadataResponse;
import com.google.android.gms.drive.internal.SetResourceParentsRequest;
import com.google.android.gms.drive.internal.TrashResourceRequest;
import com.google.android.gms.drive.internal.UntrashResourceRequest;
import com.google.android.gms.drive.internal.UpdateMetadataRequest;
import com.google.android.gms.drive.internal.zzan;
import com.google.android.gms.drive.internal.zzbt;
import com.google.android.gms.drive.internal.zzp;
import com.google.android.gms.drive.internal.zzs;
import com.google.android.gms.drive.internal.zzt;
import com.google.android.gms.drive.internal.zzu;
import com.google.android.gms.internal.zzlx;
import java.util.ArrayList;
import java.util.Set;

public class zzab
implements DriveResource {
    protected final DriveId zzamF;

    public zzab(DriveId driveId) {
        this.zzamF = driveId;
    }

    @Override
    public DriveId getDriveId() {
        return this.zzamF;
    }

    @Override
    public PendingResult<DriveResource.MetadataResult> getMetadata(GoogleApiClient apiClient) {
        return this.zza(apiClient, false);
    }

    private PendingResult<DriveResource.MetadataResult> zza(GoogleApiClient googleApiClient, final boolean bl) {
        return googleApiClient.zza((zzlx.zza)new zzd(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzsF().zza(new GetMetadataRequest(zzab.this.zzamF, bl), (zzan)new zzb((zzlx.zzb<DriveResource.MetadataResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> listParents(GoogleApiClient apiClient) {
        return apiClient.zza((zzlx.zza)new zzs.zzh(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzsF().zza(new ListParentsRequest(zzab.this.zzamF), (zzan)new zza((zzlx.zzb<DriveApi.MetadataBufferResult>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> setParents(GoogleApiClient apiClient, Set<DriveId> parentIds) {
        if (parentIds == null) {
            throw new IllegalArgumentException("ParentIds must be provided.");
        }
        final ArrayList<DriveId> arrayList = new ArrayList<DriveId>(parentIds);
        return apiClient.zzb((zzlx.zza)new zzt.zza(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzsF().zza(new SetResourceParentsRequest(zzab.this.zzamF, arrayList), (zzan)new zzbt((zzlx.zzb<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveResource.MetadataResult> updateMetadata(GoogleApiClient apiClient, final MetadataChangeSet changeSet) {
        if (changeSet == null) {
            throw new IllegalArgumentException("ChangeSet must be provided.");
        }
        return apiClient.zzb((zzlx.zza)new zzd(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                changeSet.zzsp().setContext(zzu2.getContext());
                zzu2.zzsF().zza(new UpdateMetadataRequest(zzab.this.zzamF, changeSet.zzsp()), (zzan)new zzb((zzlx.zzb<DriveResource.MetadataResult>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> delete(GoogleApiClient apiClient) {
        return apiClient.zzb((zzlx.zza)new zzt.zza(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzsF().zza(new DeleteResourceRequest(zzab.this.zzamF), (zzan)new zzbt((zzlx.zzb<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> addChangeListener(GoogleApiClient apiClient, ChangeListener listener) {
        zzu zzu2 = (zzu)apiClient.zza(Drive.zzTo);
        return zzu2.zza(apiClient, this.zzamF, listener);
    }

    @Override
    public PendingResult<Status> removeChangeListener(GoogleApiClient apiClient, ChangeListener listener) {
        zzu zzu2 = (zzu)apiClient.zza(Drive.zzTo);
        return zzu2.zzb(apiClient, this.zzamF, listener);
    }

    @Override
    public PendingResult<Status> addChangeSubscription(GoogleApiClient apiClient) {
        zzu zzu2 = (zzu)apiClient.zza(Drive.zzTo);
        return zzu2.zza(apiClient, this.zzamF);
    }

    @Override
    public PendingResult<Status> removeChangeSubscription(GoogleApiClient apiClient) {
        zzu zzu2 = (zzu)apiClient.zza(Drive.zzTo);
        return zzu2.zzb(apiClient, this.zzamF);
    }

    @Override
    public PendingResult<Status> trash(GoogleApiClient apiClient) {
        return apiClient.zzb((zzlx.zza)new zzt.zza(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzsF().zza(new TrashResourceRequest(zzab.this.zzamF), (zzan)new zzbt((zzlx.zzb<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> untrash(GoogleApiClient apiClient) {
        return apiClient.zzb((zzlx.zza)new zzt.zza(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzsF().zza(new UntrashResourceRequest(zzab.this.zzamF), (zzan)new zzbt((zzlx.zzb<Status>)this));
            }
        });
    }

    private static class zza
    extends com.google.android.gms.drive.internal.zzd {
        private final zzlx.zzb<DriveApi.MetadataBufferResult> zzakL;

        public zza(zzlx.zzb<DriveApi.MetadataBufferResult> zzb2) {
            this.zzakL = zzb2;
        }

        @Override
        public void zza(OnListParentsResponse onListParentsResponse) throws RemoteException {
            MetadataBuffer metadataBuffer = new MetadataBuffer(onListParentsResponse.zzsW());
            this.zzakL.zzr((Object)new zzs.zzg(Status.zzaeX, metadataBuffer, false));
        }

        @Override
        public void zzA(Status status) throws RemoteException {
            this.zzakL.zzr((Object)new zzs.zzg(status, null, false));
        }
    }

    private static class zzb
    extends com.google.android.gms.drive.internal.zzd {
        private final zzlx.zzb<DriveResource.MetadataResult> zzakL;

        public zzb(zzlx.zzb<DriveResource.MetadataResult> zzb2) {
            this.zzakL = zzb2;
        }

        @Override
        public void zza(OnMetadataResponse onMetadataResponse) throws RemoteException {
            this.zzakL.zzr((Object)new zzc(Status.zzaeX, new zzp(onMetadataResponse.zzsX())));
        }

        @Override
        public void zzA(Status status) throws RemoteException {
            this.zzakL.zzr((Object)new zzc(status, null));
        }
    }

    private static class zzc
    implements DriveResource.MetadataResult {
        private final Status zzTA;
        private final Metadata zzapw;

        public zzc(Status status, Metadata metadata) {
            this.zzTA = status;
            this.zzapw = metadata;
        }

        public Status getStatus() {
            return this.zzTA;
        }

        @Override
        public Metadata getMetadata() {
            return this.zzapw;
        }
    }

    private abstract class zzd
    extends zzt<DriveResource.MetadataResult> {
        private zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveResource.MetadataResult zzI(Status status) {
            return new zzc(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzI(status);
        }
    }
}

