/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.ChangesAvailableOptions;
import com.google.android.gms.drive.events.zzc;
import com.google.android.gms.drive.events.zzg;
import com.google.android.gms.drive.events.zzi;
import com.google.android.gms.drive.internal.AddEventListenerRequest;
import com.google.android.gms.drive.internal.CancelPendingActionsRequest;
import com.google.android.gms.drive.internal.DisconnectRequest;
import com.google.android.gms.drive.internal.RemoveEventListenerRequest;
import com.google.android.gms.drive.internal.zzae;
import com.google.android.gms.drive.internal.zzam;
import com.google.android.gms.drive.internal.zzan;
import com.google.android.gms.drive.internal.zzao;
import com.google.android.gms.drive.internal.zzbt;
import com.google.android.gms.drive.internal.zzs;
import com.google.android.gms.drive.internal.zzt;
import com.google.android.gms.internal.zzlx;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class zzu
extends zzj<zzam> {
    private final String zzTz;
    private final Bundle zzaoH;
    private final boolean zzaoI;
    private volatile DriveId zzaoJ;
    private volatile DriveId zzaoK;
    private volatile boolean zzaoL = false;
    final GoogleApiClient.ConnectionCallbacks zzajO;
    final Map<DriveId, Map<ChangeListener, zzae>> zzaoM = new HashMap<DriveId, Map<ChangeListener, zzae>>();
    final Map<zzc, zzae> zzaoN = new HashMap<zzc, zzae>();
    final Map<DriveId, Map<zzi, zzae>> zzaoO = new HashMap<DriveId, Map<zzi, zzae>>();
    final Map<DriveId, Map<zzi, zzae>> zzaoP = new HashMap<DriveId, Map<zzi, zzae>>();

    public zzu(Context context, Looper looper, zzf zzf2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, Bundle bundle) {
        super(context, looper, 11, zzf2, connectionCallbacks, onConnectionFailedListener);
        this.zzTz = zzf2.zzqd();
        this.zzajO = connectionCallbacks;
        this.zzaoH = bundle;
        Intent intent = new Intent("com.google.android.gms.drive.events.HANDLE_EVENT");
        intent.setPackage(context.getPackageName());
        List list = context.getPackageManager().queryIntentServices(intent, 0);
        switch (list.size()) {
            case 0: {
                this.zzaoI = false;
                break;
            }
            case 1: {
                ServiceInfo serviceInfo = ((ResolveInfo)list.get((int)0)).serviceInfo;
                if (!serviceInfo.exported) {
                    throw new IllegalStateException("Drive event service " + serviceInfo.name + " must be exported in AndroidManifest.xml");
                }
                this.zzaoI = true;
                break;
            }
            default: {
                throw new IllegalStateException("AndroidManifest.xml can only define one service that handles the " + intent.getAction() + " action");
            }
        }
    }

    public boolean zzmn() {
        return !this.getContext().getPackageName().equals(this.zzTz) || !this.zzsE();
    }

    public boolean zzqu() {
        return true;
    }

    boolean zzsE() {
        return GooglePlayServicesUtil.zze((Context)this.getContext(), (int)Process.myUid());
    }

    protected zzam zzaZ(IBinder iBinder) {
        return zzam.zza.zzba(iBinder);
    }

    protected String zzgi() {
        return "com.google.android.gms.drive.internal.IDriveService";
    }

    protected Bundle zzlU() {
        String string = this.getContext().getPackageName();
        zzx.zzy((Object)string);
        zzx.zzaa((!this.zzqq().zzqb().isEmpty() ? 1 : 0) != 0);
        Bundle bundle = new Bundle();
        if (!string.equals(this.zzTz)) {
            bundle.putString("proxy_package_name", this.zzTz);
        }
        bundle.putAll(this.zzaoH);
        return bundle;
    }

    protected String zzgh() {
        return "com.google.android.gms.drive.ApiService.START";
    }

    public zzam zzsF() throws DeadObjectException {
        return (zzam)this.zzqs();
    }

    public DriveId zzsG() {
        return this.zzaoJ;
    }

    public DriveId zzsH() {
        return this.zzaoK;
    }

    public boolean zzsI() {
        return this.zzaoL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Map<Object, Object> map;
        if (this.isConnected()) {
            try {
                map = (zzam)this.zzqs();
                map.zza(new DisconnectRequest());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        super.disconnect();
        map = this.zzaoM;
        synchronized (map) {
            this.zzaoM.clear();
        }
        map = this.zzaoN;
        synchronized (map) {
            this.zzaoN.clear();
        }
        map = this.zzaoO;
        synchronized (map) {
            this.zzaoO.clear();
        }
        map = this.zzaoP;
        synchronized (map) {
            this.zzaoP.clear();
        }
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (bundle != null) {
            bundle.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.zzaoJ = (DriveId)bundle.getParcelable("com.google.android.gms.drive.root_id");
            this.zzaoK = (DriveId)bundle.getParcelable("com.google.android.gms.drive.appdata_id");
            this.zzaoL = true;
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public boolean zzsJ() {
        return this.zzaoI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        int n = 1;
        zzx.zzb((boolean)zzg.zza(n, driveId), (Object)"id");
        zzx.zzb((Object)changeListener, (Object)"listener");
        zzx.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        Map<DriveId, Map<ChangeListener, zzae>> map = this.zzaoM;
        synchronized (map) {
            zzae zzae2;
            Map<ChangeListener, zzae> map2 = this.zzaoM.get(driveId);
            if (map2 == null) {
                map2 = new HashMap<ChangeListener, zzae>();
                this.zzaoM.put(driveId, map2);
            }
            if ((zzae2 = map2.get(changeListener)) == null) {
                zzae2 = new zzae(this.getLooper(), this.getContext(), n, changeListener);
                map2.put(changeListener, zzae2);
            } else if (zzae2.zzde(n)) {
                return new zzs.zzj(googleApiClient, Status.zzaeX);
            }
            zzae2.zzdd(n);
            return this.zza(googleApiClient, n, driveId, zzae2, null);
        }
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final int n, final DriveId driveId, final zzae zzae2, final ChangesAvailableOptions changesAvailableOptions) {
        return googleApiClient.zzb((zzlx.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzsF().zza(new AddEventListenerRequest(driveId, n, changesAvailableOptions), (zzao)zzae2, null, (zzan)new zzbt((zzlx.zzb<Status>)this));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingResult<Status> zzb(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        int n = 1;
        zzx.zzb((boolean)zzg.zza(n, driveId), (Object)"id");
        zzx.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        zzx.zzb((Object)changeListener, (Object)"listener");
        Map<DriveId, Map<ChangeListener, zzae>> map = this.zzaoM;
        synchronized (map) {
            Map<ChangeListener, zzae> map2 = this.zzaoM.get(driveId);
            if (map2 == null) {
                return new zzs.zzj(googleApiClient, Status.zzaeX);
            }
            zzae zzae2 = map2.remove(changeListener);
            if (zzae2 == null) {
                return new zzs.zzj(googleApiClient, Status.zzaeX);
            }
            if (map2.isEmpty()) {
                this.zzaoM.remove(driveId);
            }
            return this.zza(googleApiClient, n, driveId, zzae2);
        }
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final int n, final DriveId driveId, final zzae zzae2) {
        return googleApiClient.zzb((zzlx.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzsF().zza(new RemoveEventListenerRequest(driveId, n), (zzao)zzae2, null, (zzan)new zzbt((zzlx.zzb<Status>)this));
            }
        });
    }

    PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId) {
        return this.zza(googleApiClient, 1, driveId, (ChangesAvailableOptions)null);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final int n, final DriveId driveId, final ChangesAvailableOptions changesAvailableOptions) {
        zzx.zzb((boolean)zzg.zza(n, driveId), (Object)"id");
        zzx.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        if (!this.zzaoI) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to add event subscriptions");
        }
        return googleApiClient.zzb((zzlx.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzsF().zza(new AddEventListenerRequest(driveId, n, changesAvailableOptions), null, null, (zzan)new zzbt((zzlx.zzb<Status>)this));
            }
        });
    }

    PendingResult<Status> zzb(GoogleApiClient googleApiClient, DriveId driveId) {
        return this.zza(googleApiClient, 1, driveId);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final int n, final DriveId driveId) {
        zzx.zzb((boolean)zzg.zza(n, driveId), (Object)"id");
        zzx.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        return googleApiClient.zzb((zzlx.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzsF().zza(new RemoveEventListenerRequest(driveId, n), null, null, (zzan)new zzbt((zzlx.zzb<Status>)this));
            }
        });
    }

    PendingResult<Status> cancelPendingActions(GoogleApiClient apiClient, final List<String> pendingTags) {
        zzx.zzab((pendingTags != null ? 1 : 0) != 0);
        zzx.zzab((!pendingTags.isEmpty() ? 1 : 0) != 0);
        zzx.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        return apiClient.zzb((zzlx.zza)new zzt.zza(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzsF().zza(new CancelPendingActionsRequest(pendingTags), (zzan)new zzbt((zzlx.zzb<Status>)this));
            }
        });
    }

    protected /* synthetic */ IInterface zzW(IBinder iBinder) {
        return this.zzaZ(iBinder);
    }
}

