/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.text.TextUtils;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.internal.zzu;

public class ExecutionOptions {
    public static final int MAX_TRACKING_TAG_STRING_LENGTH = 65536;
    public static final int CONFLICT_STRATEGY_OVERWRITE_REMOTE = 0;
    public static final int CONFLICT_STRATEGY_KEEP_REMOTE = 1;
    private final String zzaoV;
    private final boolean zzaoW;
    private final int zzaoX;

    public ExecutionOptions(String trackingTag, boolean notifyOnCompletion, int conflictStrategy) {
        this.zzaoV = trackingTag;
        this.zzaoW = notifyOnCompletion;
        this.zzaoX = conflictStrategy;
    }

    public String zzsB() {
        return this.zzaoV;
    }

    public boolean zzsC() {
        return this.zzaoW;
    }

    public int zzsD() {
        return this.zzaoX;
    }

    public static boolean zzcv(int n) {
        switch (n) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean zzcw(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean zzcX(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && string.length() <= 65536;
    }

    public void zzg(GoogleApiClient googleApiClient) {
        zzu zzu2 = (zzu)googleApiClient.zza(Drive.zzUI);
        if (this.zzsC() && !zzu2.zzti()) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to be notified on completion");
        }
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ExecutionOptions executionOptions = (ExecutionOptions)o;
        return zzw.equal((Object)this.zzaoV, (Object)executionOptions.zzaoV) && this.zzaoX == executionOptions.zzaoX && this.zzaoW == executionOptions.zzaoW;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzaoV, this.zzaoX, this.zzaoW});
    }

    public static class Builder {
        protected String zzaoV;
        protected boolean zzaoW;
        protected int zzaoX = 0;

        public Builder setTrackingTag(String trackingTag) {
            if (!ExecutionOptions.zzcX(trackingTag)) {
                throw new IllegalArgumentException(String.format("trackingTag must not be null nor empty, and the length must be <= the maximum length (%s)", 65536));
            }
            this.zzaoV = trackingTag;
            return this;
        }

        public Builder setNotifyOnCompletion(boolean notify) {
            this.zzaoW = notify;
            return this;
        }

        public Builder setConflictStrategy(int strategy) {
            if (!ExecutionOptions.zzcw(strategy)) {
                throw new IllegalArgumentException("Unrecognized value for conflict strategy: " + strategy);
            }
            this.zzaoX = strategy;
            return this;
        }

        protected void zzsE() {
            if (this.zzaoX == 1 && !this.zzaoW) {
                throw new IllegalStateException("Cannot use CONFLICT_STRATEGY_KEEP_REMOTE without requesting completion notifications");
            }
        }

        public ExecutionOptions build() {
            this.zzsE();
            return new ExecutionOptions(this.zzaoV, this.zzaoW, this.zzaoX);
        }
    }
}

