/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.content.IntentSender;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.internal.OpenFileIntentSenderRequest;
import com.google.android.gms.drive.internal.zzam;
import com.google.android.gms.drive.internal.zzu;
import com.google.android.gms.drive.query.Filter;
import com.google.android.gms.drive.query.internal.FilterHolder;
import com.google.android.gms.drive.query.internal.zzg;

public class OpenFileActivityBuilder {
    public static final String EXTRA_RESPONSE_DRIVE_ID = "response_drive_id";
    private String zzapg;
    private String[] zzaph;
    private Filter zzapi;
    private DriveId zzapj;

    public OpenFileActivityBuilder setActivityTitle(String title) {
        this.zzapg = (String)zzx.zzz((Object)title);
        return this;
    }

    public OpenFileActivityBuilder setMimeType(String[] mimeTypes) {
        zzx.zzb((mimeTypes != null ? 1 : 0) != 0, (Object)"mimeTypes may not be null");
        this.zzaph = mimeTypes;
        return this;
    }

    public OpenFileActivityBuilder setSelectionFilter(Filter filter) {
        zzx.zzb((filter != null ? 1 : 0) != 0, (Object)"filter may not be null");
        zzx.zzb((!zzg.zza(filter) ? 1 : 0) != 0, (Object)"FullTextSearchFilter cannot be used as a selection filter");
        this.zzapi = filter;
        return this;
    }

    public OpenFileActivityBuilder setActivityStartFolder(DriveId folder) {
        this.zzapj = (DriveId)zzx.zzz((Object)folder);
        return this;
    }

    public IntentSender build(GoogleApiClient apiClient) {
        zzx.zza((boolean)apiClient.isConnected(), (Object)"Client must be connected");
        if (this.zzaph == null) {
            this.zzaph = new String[0];
        }
        if (this.zzaph.length > 0 && this.zzapi != null) {
            throw new IllegalStateException("Cannot use a selection filter and set mimetypes simultaneously");
        }
        FilterHolder filterHolder = this.zzapi == null ? null : new FilterHolder(this.zzapi);
        try {
            zzam zzam2 = ((zzu)apiClient.zza(Drive.zzUI)).zzte();
            return zzam2.zza(new OpenFileIntentSenderRequest(this.zzapg, this.zzaph, this.zzapj, filterHolder));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Unable to connect Drive Play Service", remoteException);
        }
    }
}

