/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ResourceEvent;
import com.google.android.gms.drive.events.zze;
import com.google.android.gms.drive.internal.zzap;
import com.google.android.gms.drive.internal.zzz;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzna;
import com.google.android.gms.internal.zznm;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class CompletionEvent
implements SafeParcelable,
ResourceEvent {
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_FAILURE = 1;
    public static final int STATUS_CONFLICT = 2;
    public static final int STATUS_CANCELED = 3;
    public static final Parcelable.Creator<CompletionEvent> CREATOR = new zze();
    final int mVersionCode;
    final DriveId zzaoz;
    final String zzVa;
    final ParcelFileDescriptor zzapD;
    final ParcelFileDescriptor zzapE;
    final MetadataBundle zzapF;
    final List<String> zzapG;
    final int zzBc;
    final IBinder zzapH;
    private boolean zzapI = false;
    private boolean zzapJ = false;
    private boolean zzapK = false;

    CompletionEvent(int versionCode, DriveId driveId, String accountName, ParcelFileDescriptor baseParcelFileDescriptor, ParcelFileDescriptor modifiedParcelFileDescriptor, MetadataBundle modifiedMetadataBundle, List<String> trackingTags, int status, IBinder releaseCallback) {
        this.mVersionCode = versionCode;
        this.zzaoz = driveId;
        this.zzVa = accountName;
        this.zzapD = baseParcelFileDescriptor;
        this.zzapE = modifiedParcelFileDescriptor;
        this.zzapF = modifiedMetadataBundle;
        this.zzapG = trackingTags;
        this.zzBc = status;
        this.zzapH = releaseCallback;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zze.zza(this, dest, flags | 1);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public DriveId getDriveId() {
        this.zzsU();
        return this.zzaoz;
    }

    public String getAccountName() {
        this.zzsU();
        return this.zzVa;
    }

    public InputStream getBaseContentsInputStream() {
        this.zzsU();
        if (this.zzapD == null) {
            return null;
        }
        if (this.zzapI) {
            throw new IllegalStateException("getBaseInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzapI = true;
        return new FileInputStream(this.zzapD.getFileDescriptor());
    }

    public InputStream getModifiedContentsInputStream() {
        this.zzsU();
        if (this.zzapE == null) {
            return null;
        }
        if (this.zzapJ) {
            throw new IllegalStateException("getModifiedInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzapJ = true;
        return new FileInputStream(this.zzapE.getFileDescriptor());
    }

    public MetadataChangeSet getModifiedMetadataChangeSet() {
        this.zzsU();
        return this.zzapF != null ? new MetadataChangeSet(this.zzapF) : null;
    }

    public List<String> getTrackingTags() {
        this.zzsU();
        return new ArrayList<String>(this.zzapG);
    }

    public int getStatus() {
        this.zzsU();
        return this.zzBc;
    }

    public void dismiss() {
        this.zzv(false);
    }

    public void snooze() {
        this.zzv(true);
    }

    private void zzv(boolean bl) {
        this.zzsU();
        this.zzapK = true;
        zzna.zza((ParcelFileDescriptor)this.zzapD);
        zzna.zza((ParcelFileDescriptor)this.zzapE);
        if (this.zzapF != null && this.zzapF.zzc(zznm.zzatz)) {
            this.zzapF.zza(zznm.zzatz).release();
        }
        if (this.zzapH == null) {
            zzz.zzA("CompletionEvent", "No callback on " + (bl ? "snooze" : "dismiss"));
            return;
        }
        try {
            zzap.zza.zzbd(this.zzapH).zzv(bl);
        }
        catch (RemoteException remoteException) {
            zzz.zzA("CompletionEvent", "RemoteException on " + (bl ? "snooze" : "dismiss") + ": " + (Object)((Object)remoteException));
        }
    }

    private void zzsU() {
        if (this.zzapK) {
            throw new IllegalStateException("Event has already been dismissed or snoozed.");
        }
    }

    public String toString() {
        String string = this.zzapG == null ? "<null>" : "'" + TextUtils.join((CharSequence)"','", this.zzapG) + "'";
        return String.format(Locale.US, "CompletionEvent [id=%s, status=%s, trackingTag=%s]", this.zzaoz, this.zzBc, string);
    }
}

