/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.drive.events.ChangeEvent;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.ChangesAvailableEvent;
import com.google.android.gms.drive.events.CompletionEvent;
import com.google.android.gms.drive.events.CompletionListener;
import com.google.android.gms.drive.events.DriveEvent;
import com.google.android.gms.drive.events.TransferStateEvent;
import com.google.android.gms.drive.events.zzc;
import com.google.android.gms.drive.events.zzq;
import com.google.android.gms.drive.internal.OnEventResponse;
import com.google.android.gms.drive.internal.zzao;
import com.google.android.gms.drive.internal.zzz;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class DriveEventService
extends Service
implements ChangeListener,
CompletionListener,
zzc,
zzq {
    public static final String ACTION_HANDLE_EVENT = "com.google.android.gms.drive.events.HANDLE_EVENT";
    private final String mName;
    private CountDownLatch zzapL;
    zza zzapM;
    boolean zzapN = false;
    int zzakz = -1;

    protected DriveEventService(String name) {
        this.mName = name;
    }

    protected DriveEventService() {
        this("DriveEventService");
    }

    public final synchronized IBinder onBind(Intent intent) {
        if (ACTION_HANDLE_EVENT.equals(intent.getAction())) {
            if (this.zzapM == null && !this.zzapN) {
                this.zzapN = true;
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                this.zzapL = new CountDownLatch(1);
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Looper.prepare();
                            DriveEventService.this.zzapM = new zza();
                            DriveEventService.this.zzapN = false;
                            countDownLatch.countDown();
                            zzz.zzy("DriveEventService", "Bound and starting loop");
                            Looper.loop();
                            zzz.zzy("DriveEventService", "Finished loop");
                        }
                        finally {
                            if (DriveEventService.this.zzapL != null) {
                                DriveEventService.this.zzapL.countDown();
                            }
                        }
                    }
                }.start();
                try {
                    boolean bl = countDownLatch.await(5000L, TimeUnit.MILLISECONDS);
                    if (!bl) {
                        zzz.zzA("DriveEventService", "Failed to synchronously initialize event handler.");
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException("Unable to start event handler", interruptedException);
                }
            }
            return new zzb().asBinder();
        }
        return null;
    }

    public boolean onUnbind(Intent intent) {
        return true;
    }

    public synchronized void onDestroy() {
        zzz.zzy("DriveEventService", "onDestroy");
        if (this.zzapM != null) {
            Message message = this.zzapM.zzsW();
            this.zzapM.sendMessage(message);
            this.zzapM = null;
            try {
                boolean bl = this.zzapL.await(5000L, TimeUnit.MILLISECONDS);
                if (!bl) {
                    zzz.zzz("DriveEventService", "Failed to synchronously quit event handler. Will quit itself");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.zzapL = null;
        }
        super.onDestroy();
    }

    @Override
    public void onChange(ChangeEvent event) {
        zzz.zzz(this.mName, "Unhandled change event: " + event);
    }

    @Override
    public void zza(ChangesAvailableEvent changesAvailableEvent) {
        zzz.zzz(this.mName, "Unhandled changes available event: " + changesAvailableEvent);
    }

    @Override
    public void onCompletion(CompletionEvent event) {
        zzz.zzz(this.mName, "Unhandled completion event: " + event);
    }

    public void zza(TransferStateEvent transferStateEvent) {
        zzz.zzz(this.mName, "Unhandled transfer state event: " + transferStateEvent);
    }

    protected int getCallingUid() {
        return Binder.getCallingUid();
    }

    private void zza(OnEventResponse onEventResponse) {
        DriveEvent driveEvent = onEventResponse.zzts();
        zzz.zzy("DriveEventService", "handleEventMessage: " + driveEvent);
        try {
            switch (driveEvent.getType()) {
                case 1: {
                    this.onChange((ChangeEvent)driveEvent);
                    break;
                }
                case 2: {
                    this.onCompletion((CompletionEvent)driveEvent);
                    break;
                }
                case 4: {
                    this.zza((ChangesAvailableEvent)driveEvent);
                    break;
                }
                case 7: {
                    this.zza((TransferStateEvent)driveEvent);
                    break;
                }
                default: {
                    zzz.zzz(this.mName, "Unhandled event: " + driveEvent);
                    break;
                }
            }
        }
        catch (Exception exception) {
            zzz.zza(this.mName, exception, "Error handling event: " + driveEvent);
        }
    }

    private void zzsV() throws SecurityException {
        int n = this.getCallingUid();
        if (n == this.zzakz) {
            return;
        }
        if (GooglePlayServicesUtil.zzf((Context)this, (int)n)) {
            this.zzakz = n;
            return;
        }
        throw new SecurityException("Caller is not GooglePlayServices");
    }

    final class zzb
    extends zzao.zza {
        zzb() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzc(OnEventResponse onEventResponse) throws RemoteException {
            DriveEventService driveEventService = DriveEventService.this;
            synchronized (driveEventService) {
                zzz.zzy("DriveEventService", "onEvent: " + onEventResponse);
                DriveEventService.this.zzsV();
                if (DriveEventService.this.zzapM != null) {
                    Message message = DriveEventService.this.zzapM.zzb(onEventResponse);
                    DriveEventService.this.zzapM.sendMessage(message);
                } else {
                    zzz.zzA("DriveEventService", "Receiving event before initialize is completed.");
                }
            }
        }
    }

    final class zza
    extends Handler {
        zza() {
        }

        private Message zzb(OnEventResponse onEventResponse) {
            return this.obtainMessage(1, onEventResponse);
        }

        private Message zzsW() {
            return this.obtainMessage(2);
        }

        public void handleMessage(Message msg) {
            zzz.zzy("DriveEventService", "handleMessage message type:" + msg.what);
            switch (msg.what) {
                case 1: {
                    DriveEventService.this.zza((OnEventResponse)msg.obj);
                    break;
                }
                case 2: {
                    this.getLooper().quit();
                    break;
                }
                default: {
                    zzz.zzz("DriveEventService", "Unexpected message type:" + msg.what);
                }
            }
        }
    }
}

