/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.Metadata;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.internal.DeleteResourceRequest;
import com.google.android.gms.drive.internal.GetMetadataRequest;
import com.google.android.gms.drive.internal.ListParentsRequest;
import com.google.android.gms.drive.internal.OnListParentsResponse;
import com.google.android.gms.drive.internal.OnMetadataResponse;
import com.google.android.gms.drive.internal.SetResourceParentsRequest;
import com.google.android.gms.drive.internal.TrashResourceRequest;
import com.google.android.gms.drive.internal.UntrashResourceRequest;
import com.google.android.gms.drive.internal.UpdateMetadataRequest;
import com.google.android.gms.drive.internal.zzan;
import com.google.android.gms.drive.internal.zzbu;
import com.google.android.gms.drive.internal.zzp;
import com.google.android.gms.drive.internal.zzs;
import com.google.android.gms.drive.internal.zzt;
import com.google.android.gms.drive.internal.zzu;
import java.util.ArrayList;
import java.util.Set;

public class zzab
implements DriveResource {
    protected final DriveId zzaoz;

    public zzab(DriveId driveId) {
        this.zzaoz = driveId;
    }

    @Override
    public DriveId getDriveId() {
        return this.zzaoz;
    }

    @Override
    public PendingResult<DriveResource.MetadataResult> getMetadata(GoogleApiClient apiClient) {
        return this.zza(apiClient, false);
    }

    private PendingResult<DriveResource.MetadataResult> zza(GoogleApiClient googleApiClient, final boolean bl) {
        return googleApiClient.zza((zza.zza)new zzd(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzte().zza(new GetMetadataRequest(zzab.this.zzaoz, bl), (zzan)new zzb((zza.zzb<DriveResource.MetadataResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> listParents(GoogleApiClient apiClient) {
        return apiClient.zza((zza.zza)new zzs.zzh(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzte().zza(new ListParentsRequest(zzab.this.zzaoz), (zzan)new zza((zza.zzb<DriveApi.MetadataBufferResult>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> setParents(GoogleApiClient apiClient, Set<DriveId> parentIds) {
        if (parentIds == null) {
            throw new IllegalArgumentException("ParentIds must be provided.");
        }
        final ArrayList<DriveId> arrayList = new ArrayList<DriveId>(parentIds);
        return apiClient.zzb((zza.zza)new zzt.zza(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzte().zza(new SetResourceParentsRequest(zzab.this.zzaoz, arrayList), (zzan)new zzbu((zza.zzb<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveResource.MetadataResult> updateMetadata(GoogleApiClient apiClient, final MetadataChangeSet changeSet) {
        if (changeSet == null) {
            throw new IllegalArgumentException("ChangeSet must be provided.");
        }
        return apiClient.zzb((zza.zza)new zzd(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                changeSet.zzsL().setContext(zzu2.getContext());
                zzu2.zzte().zza(new UpdateMetadataRequest(zzab.this.zzaoz, changeSet.zzsL()), (zzan)new zzb((zza.zzb<DriveResource.MetadataResult>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> delete(GoogleApiClient apiClient) {
        return apiClient.zzb((zza.zza)new zzt.zza(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzte().zza(new DeleteResourceRequest(zzab.this.zzaoz), (zzan)new zzbu((zza.zzb<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> addChangeListener(GoogleApiClient apiClient, ChangeListener listener) {
        zzu zzu2 = (zzu)apiClient.zza(Drive.zzUI);
        return zzu2.zza(apiClient, this.zzaoz, listener);
    }

    @Override
    public PendingResult<Status> removeChangeListener(GoogleApiClient apiClient, ChangeListener listener) {
        zzu zzu2 = (zzu)apiClient.zza(Drive.zzUI);
        return zzu2.zzb(apiClient, this.zzaoz, listener);
    }

    @Override
    public PendingResult<Status> addChangeSubscription(GoogleApiClient apiClient) {
        zzu zzu2 = (zzu)apiClient.zza(Drive.zzUI);
        return zzu2.zza(apiClient, this.zzaoz);
    }

    @Override
    public PendingResult<Status> removeChangeSubscription(GoogleApiClient apiClient) {
        zzu zzu2 = (zzu)apiClient.zza(Drive.zzUI);
        return zzu2.zzb(apiClient, this.zzaoz);
    }

    @Override
    public PendingResult<Status> trash(GoogleApiClient apiClient) {
        return apiClient.zzb((zza.zza)new zzt.zza(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzte().zza(new TrashResourceRequest(zzab.this.zzaoz), (zzan)new zzbu((zza.zzb<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> untrash(GoogleApiClient apiClient) {
        return apiClient.zzb((zza.zza)new zzt.zza(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzte().zza(new UntrashResourceRequest(zzab.this.zzaoz), (zzan)new zzbu((zza.zzb<Status>)this));
            }
        });
    }

    private static class zza
    extends com.google.android.gms.drive.internal.zzd {
        private final zza.zzb<DriveApi.MetadataBufferResult> zzamC;

        public zza(zza.zzb<DriveApi.MetadataBufferResult> zzb2) {
            this.zzamC = zzb2;
        }

        @Override
        public void zza(OnListParentsResponse onListParentsResponse) throws RemoteException {
            MetadataBuffer metadataBuffer = new MetadataBuffer(onListParentsResponse.zztv());
            this.zzamC.zzs((Object)new zzs.zzg(Status.zzagC, metadataBuffer, false));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.zzamC.zzs((Object)new zzs.zzg(status, null, false));
        }
    }

    private static class zzb
    extends com.google.android.gms.drive.internal.zzd {
        private final zza.zzb<DriveResource.MetadataResult> zzamC;

        public zzb(zza.zzb<DriveResource.MetadataResult> zzb2) {
            this.zzamC = zzb2;
        }

        @Override
        public void zza(OnMetadataResponse onMetadataResponse) throws RemoteException {
            this.zzamC.zzs((Object)new zzc(Status.zzagC, new zzp(onMetadataResponse.zztw())));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.zzamC.zzs((Object)new zzc(status, null));
        }
    }

    private static class zzc
    implements DriveResource.MetadataResult {
        private final Status zzUX;
        private final Metadata zzarA;

        public zzc(Status status, Metadata metadata) {
            this.zzUX = status;
            this.zzarA = metadata;
        }

        public Status getStatus() {
            return this.zzUX;
        }

        @Override
        public Metadata getMetadata() {
            return this.zzarA;
        }
    }

    private abstract class zzd
    extends zzt<DriveResource.MetadataResult> {
        private zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveResource.MetadataResult zzH(Status status) {
            return new zzc(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzH(status);
        }
    }
}

