/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.zzc;
import com.google.android.gms.drive.events.zzg;
import com.google.android.gms.drive.events.zzi;
import com.google.android.gms.drive.internal.AddEventListenerRequest;
import com.google.android.gms.drive.internal.CancelPendingActionsRequest;
import com.google.android.gms.drive.internal.DisconnectRequest;
import com.google.android.gms.drive.internal.RemoveEventListenerRequest;
import com.google.android.gms.drive.internal.zzae;
import com.google.android.gms.drive.internal.zzam;
import com.google.android.gms.drive.internal.zzan;
import com.google.android.gms.drive.internal.zzao;
import com.google.android.gms.drive.internal.zzbu;
import com.google.android.gms.drive.internal.zzs;
import com.google.android.gms.drive.internal.zzt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class zzu
extends zzj<zzam> {
    private final String zzUW;
    private final Bundle zzaqK;
    private final boolean zzaqL;
    private volatile DriveId zzaqM;
    private volatile DriveId zzaqN;
    private volatile boolean zzaqO = false;
    final GoogleApiClient.ConnectionCallbacks zzalF;
    final Map<DriveId, Map<ChangeListener, zzae>> zzaqP = new HashMap<DriveId, Map<ChangeListener, zzae>>();
    final Map<zzc, zzae> zzaqQ = new HashMap<zzc, zzae>();
    final Map<DriveId, Map<zzi, zzae>> zzaqR = new HashMap<DriveId, Map<zzi, zzae>>();
    final Map<DriveId, Map<zzi, zzae>> zzaqS = new HashMap<DriveId, Map<zzi, zzae>>();

    public zzu(Context context, Looper looper, zzf zzf2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, Bundle bundle) {
        super(context, looper, 11, zzf2, connectionCallbacks, onConnectionFailedListener);
        this.zzUW = zzf2.zzqv();
        this.zzalF = connectionCallbacks;
        this.zzaqK = bundle;
        Intent intent = new Intent("com.google.android.gms.drive.events.HANDLE_EVENT");
        intent.setPackage(context.getPackageName());
        List list = context.getPackageManager().queryIntentServices(intent, 0);
        switch (list.size()) {
            case 0: {
                this.zzaqL = false;
                break;
            }
            case 1: {
                ServiceInfo serviceInfo = ((ResolveInfo)list.get((int)0)).serviceInfo;
                if (!serviceInfo.exported) {
                    throw new IllegalStateException("Drive event service " + serviceInfo.name + " must be exported in AndroidManifest.xml");
                }
                this.zzaqL = true;
                break;
            }
            default: {
                throw new IllegalStateException("AndroidManifest.xml can only define one service that handles the " + intent.getAction() + " action");
            }
        }
    }

    public boolean zzmE() {
        return !this.getContext().getPackageName().equals(this.zzUW) || !this.zztd();
    }

    public boolean zzqK() {
        return true;
    }

    boolean zztd() {
        return GooglePlayServicesUtil.zzf((Context)this.getContext(), (int)Process.myUid());
    }

    protected zzam zzaZ(IBinder iBinder) {
        return zzam.zza.zzba(iBinder);
    }

    protected String zzgv() {
        return "com.google.android.gms.drive.internal.IDriveService";
    }

    protected Bundle zzml() {
        String string = this.getContext().getPackageName();
        zzx.zzz((Object)string);
        zzx.zzab((!this.zzqH().zzqt().isEmpty() ? 1 : 0) != 0);
        Bundle bundle = new Bundle();
        if (!string.equals(this.zzUW)) {
            bundle.putString("proxy_package_name", this.zzUW);
        }
        bundle.putAll(this.zzaqK);
        return bundle;
    }

    protected String zzgu() {
        return "com.google.android.gms.drive.ApiService.START";
    }

    public zzam zzte() throws DeadObjectException {
        return (zzam)this.zzqJ();
    }

    public DriveId zztf() {
        return this.zzaqM;
    }

    public DriveId zztg() {
        return this.zzaqN;
    }

    public boolean zzth() {
        return this.zzaqO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Map<Object, Object> map;
        if (this.isConnected()) {
            try {
                map = (zzam)this.zzqJ();
                map.zza(new DisconnectRequest());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        super.disconnect();
        map = this.zzaqP;
        synchronized (map) {
            this.zzaqP.clear();
        }
        map = this.zzaqQ;
        synchronized (map) {
            this.zzaqQ.clear();
        }
        map = this.zzaqR;
        synchronized (map) {
            this.zzaqR.clear();
        }
        map = this.zzaqS;
        synchronized (map) {
            this.zzaqS.clear();
        }
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (bundle != null) {
            bundle.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.zzaqM = (DriveId)bundle.getParcelable("com.google.android.gms.drive.root_id");
            this.zzaqN = (DriveId)bundle.getParcelable("com.google.android.gms.drive.appdata_id");
            this.zzaqO = true;
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public boolean zzti() {
        return this.zzaqL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        int n = 1;
        zzx.zzac((boolean)zzg.zza(n, driveId));
        zzx.zzb((Object)changeListener, (Object)"listener");
        zzx.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        Map<DriveId, Map<ChangeListener, zzae>> map = this.zzaqP;
        synchronized (map) {
            zzae zzae2;
            Map<ChangeListener, zzae> map2 = this.zzaqP.get(driveId);
            if (map2 == null) {
                map2 = new HashMap<ChangeListener, zzae>();
                this.zzaqP.put(driveId, map2);
            }
            if ((zzae2 = map2.get(changeListener)) == null) {
                zzae2 = new zzae(this.getLooper(), this.getContext(), n, changeListener);
                map2.put(changeListener, zzae2);
            } else if (zzae2.zzdh(n)) {
                return new zzs.zzj(googleApiClient, Status.zzagC);
            }
            zzae2.zzdg(n);
            return this.zza(googleApiClient, new AddEventListenerRequest(n, driveId), zzae2);
        }
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final AddEventListenerRequest addEventListenerRequest, final zzae zzae2) {
        return googleApiClient.zzb((zza.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzte().zza(addEventListenerRequest, (zzao)zzae2, null, (zzan)new zzbu((zza.zzb<Status>)this));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingResult<Status> zzb(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        int n = 1;
        zzx.zzac((boolean)zzg.zza(n, driveId));
        zzx.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        zzx.zzb((Object)changeListener, (Object)"listener");
        Map<DriveId, Map<ChangeListener, zzae>> map = this.zzaqP;
        synchronized (map) {
            Map<ChangeListener, zzae> map2 = this.zzaqP.get(driveId);
            if (map2 == null) {
                return new zzs.zzj(googleApiClient, Status.zzagC);
            }
            zzae zzae2 = map2.remove(changeListener);
            if (zzae2 == null) {
                return new zzs.zzj(googleApiClient, Status.zzagC);
            }
            if (map2.isEmpty()) {
                this.zzaqP.remove(driveId);
            }
            return this.zza(googleApiClient, new RemoveEventListenerRequest(driveId, n), zzae2);
        }
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final RemoveEventListenerRequest removeEventListenerRequest, final zzae zzae2) {
        return googleApiClient.zzb((zza.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzte().zza(removeEventListenerRequest, (zzao)zzae2, null, (zzan)new zzbu((zza.zzb<Status>)this));
            }
        });
    }

    PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId) {
        return this.zza(googleApiClient, new AddEventListenerRequest(1, driveId));
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final AddEventListenerRequest addEventListenerRequest) {
        zzx.zzac((boolean)zzg.zza(addEventListenerRequest.getEventType(), addEventListenerRequest.getDriveId()));
        zzx.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        if (!this.zzaqL) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to add event subscriptions");
        }
        return googleApiClient.zzb((zza.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzte().zza(addEventListenerRequest, null, null, (zzan)new zzbu((zza.zzb<Status>)this));
            }
        });
    }

    PendingResult<Status> zzb(GoogleApiClient googleApiClient, DriveId driveId) {
        return this.zza(googleApiClient, 1, driveId);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final int n, final DriveId driveId) {
        zzx.zzac((boolean)zzg.zza(n, driveId));
        zzx.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        return googleApiClient.zzb((zza.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzte().zza(new RemoveEventListenerRequest(driveId, n), null, null, (zzan)new zzbu((zza.zzb<Status>)this));
            }
        });
    }

    PendingResult<Status> cancelPendingActions(GoogleApiClient apiClient, final List<String> pendingTags) {
        zzx.zzac((pendingTags != null ? 1 : 0) != 0);
        zzx.zzac((!pendingTags.isEmpty() ? 1 : 0) != 0);
        zzx.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        return apiClient.zzb((zza.zza)new zzt.zza(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzte().zza(new CancelPendingActionsRequest(pendingTags), (zzan)new zzbu((zza.zzb<Status>)this));
            }
        });
    }

    protected /* synthetic */ IInterface zzW(IBinder iBinder) {
        return this.zzaZ(iBinder);
    }
}

