/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.internal.CloseContentsAndUpdateMetadataRequest;
import com.google.android.gms.drive.internal.CloseContentsRequest;
import com.google.android.gms.drive.internal.OpenContentsRequest;
import com.google.android.gms.drive.internal.zzan;
import com.google.android.gms.drive.internal.zzbl;
import com.google.android.gms.drive.internal.zzbu;
import com.google.android.gms.drive.internal.zzs;
import com.google.android.gms.drive.internal.zzt;
import com.google.android.gms.drive.internal.zzu;
import com.google.android.gms.drive.internal.zzz;
import com.google.android.gms.drive.zzi;
import com.google.android.gms.internal.zzna;
import java.io.InputStream;
import java.io.OutputStream;

public class zzv
implements DriveContents {
    private final Contents zzara;
    private boolean mClosed = false;
    private boolean zzarb = false;
    private boolean zzarc = false;

    public zzv(Contents contents) {
        this.zzara = (Contents)zzx.zzz((Object)contents);
    }

    @Override
    public DriveId getDriveId() {
        return this.zzara.getDriveId();
    }

    @Override
    public int getMode() {
        return this.zzara.getMode();
    }

    @Override
    public ParcelFileDescriptor getParcelFileDescriptor() {
        if (this.zzsz()) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        return this.zzara.getParcelFileDescriptor();
    }

    @Override
    public InputStream getInputStream() {
        if (this.zzsz()) {
            throw new IllegalStateException("Contents have been closed, cannot access the input stream.");
        }
        if (this.zzara.getMode() != 0x10000000) {
            throw new IllegalStateException("getInputStream() can only be used with contents opened with MODE_READ_ONLY.");
        }
        if (this.zzarb) {
            throw new IllegalStateException("getInputStream() can only be called once per Contents instance.");
        }
        this.zzarb = true;
        return this.zzara.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.zzsz()) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        if (this.zzara.getMode() != 0x20000000) {
            throw new IllegalStateException("getOutputStream() can only be used with contents opened with MODE_WRITE_ONLY.");
        }
        if (this.zzarc) {
            throw new IllegalStateException("getOutputStream() can only be called once per Contents instance.");
        }
        this.zzarc = true;
        return this.zzara.getOutputStream();
    }

    @Override
    public PendingResult<DriveApi.DriveContentsResult> reopenForWrite(GoogleApiClient apiClient) {
        if (this.zzsz()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.zzara.getMode() != 0x10000000) {
            throw new IllegalStateException("reopenForWrite can only be used with DriveContents opened with MODE_READ_ONLY.");
        }
        this.zzsy();
        return apiClient.zza((zza.zza)new zzs.zzc(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzte().zza(new OpenContentsRequest(zzv.this.getDriveId(), 0x20000000, zzv.this.zzara.getRequestId()), (zzan)new zzbl((zza.zzb<DriveApi.DriveContentsResult>)this, null));
            }
        });
    }

    @Override
    public PendingResult<Status> commit(GoogleApiClient apiClient, MetadataChangeSet changeSet) {
        return this.zza(apiClient, changeSet, null);
    }

    @Override
    public PendingResult<Status> commit(GoogleApiClient apiClient, MetadataChangeSet changeSet, ExecutionOptions executionOptions) {
        return this.zza(apiClient, changeSet, executionOptions == null ? null : zzi.zzb(executionOptions));
    }

    public PendingResult<Status> zza(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, zzi zzi2) {
        if (zzi2 == null) {
            zzi2 = new zzi.zza().zzsJ();
        }
        if (this.zzara.getMode() == 0x10000000) {
            throw new IllegalStateException("Cannot commit contents opened with MODE_READ_ONLY");
        }
        if (ExecutionOptions.zzcv(zzi2.zzsD()) && !this.zzara.zzsv()) {
            throw new IllegalStateException("DriveContents must be valid for conflict detection.");
        }
        zzi2.zzg(googleApiClient);
        if (this.zzsz()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.getDriveId() == null) {
            throw new IllegalStateException("Only DriveContents obtained through DriveFile.open can be committed.");
        }
        final MetadataChangeSet metadataChangeSet2 = metadataChangeSet != null ? metadataChangeSet : MetadataChangeSet.zzapd;
        final zzi zzi3 = zzi2;
        this.zzsy();
        return googleApiClient.zzb((zza.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                metadataChangeSet2.zzsL().setContext(zzu2.getContext());
                zzu2.zzte().zza(new CloseContentsAndUpdateMetadataRequest(zzv.this.zzara.getDriveId(), metadataChangeSet2.zzsL(), zzv.this.zzara.getRequestId(), zzv.this.zzara.zzsv(), zzi3), (zzan)new zzbu((zza.zzb<Status>)this));
            }
        });
    }

    @Override
    public void discard(GoogleApiClient apiClient) {
        if (this.zzsz()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        this.zzsy();
        (apiClient.zzb((zza.zza)new zzt.zza(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzte().zza(new CloseContentsRequest(zzv.this.zzara.getRequestId(), false), (zzan)new zzbu((zza.zzb<Status>)this));
            }
        })).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void zzp(Status status) {
                if (!status.isSuccess()) {
                    zzz.zzA("DriveContentsImpl", "Error discarding contents");
                } else {
                    zzz.zzy("DriveContentsImpl", "Contents discarded");
                }
            }

            public /* synthetic */ void onResult(Result result) {
                this.zzp((Status)result);
            }
        });
    }

    @Override
    public Contents zzsx() {
        return this.zzara;
    }

    @Override
    public void zzsy() {
        zzna.zza((ParcelFileDescriptor)this.zzara.getParcelFileDescriptor());
        this.mClosed = true;
    }

    @Override
    public boolean zzsz() {
        return this.mClosed;
    }
}

