/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.metadata.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.internal.zzz;
import com.google.android.gms.drive.metadata.MetadataField;
import com.google.android.gms.drive.metadata.internal.zze;
import com.google.android.gms.drive.metadata.internal.zzh;
import com.google.android.gms.internal.zznm;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public final class MetadataBundle
implements SafeParcelable {
    public static final Parcelable.Creator<MetadataBundle> CREATOR = new zzh();
    final int mVersionCode;
    final Bundle zzasQ;

    MetadataBundle(int versionCode, Bundle valueBundle) {
        this.mVersionCode = versionCode;
        this.zzasQ = (Bundle)zzx.zzz((Object)valueBundle);
        this.zzasQ.setClassLoader(this.getClass().getClassLoader());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.zzasQ.keySet()) {
            if (zze.zzdc(string) != null) continue;
            arrayList.add(string);
            zzz.zzz("MetadataBundle", "Ignored unknown metadata field in bundle: " + string);
        }
        for (String string : arrayList) {
            this.zzasQ.remove(string);
        }
    }

    private MetadataBundle(Bundle valueBundle) {
        this(1, valueBundle);
    }

    public static MetadataBundle zztE() {
        return new MetadataBundle(new Bundle());
    }

    public static <T> MetadataBundle zzb(MetadataField<T> metadataField, T t) {
        MetadataBundle metadataBundle = MetadataBundle.zztE();
        metadataBundle.zzc(metadataField, t);
        return metadataBundle;
    }

    public MetadataBundle zztF() {
        return new MetadataBundle(new Bundle(this.zzasQ));
    }

    public <T> void zzc(MetadataField<T> metadataField, T t) {
        if (zze.zzdc(metadataField.getName()) == null) {
            throw new IllegalArgumentException("Unregistered field: " + metadataField.getName());
        }
        metadataField.zza(t, this.zzasQ);
    }

    public <T> T zza(MetadataField<T> metadataField) {
        return metadataField.zzm(this.zzasQ);
    }

    public boolean zzc(MetadataField<?> metadataField) {
        return this.zzasQ.containsKey(metadataField.getName());
    }

    public Set<MetadataField<?>> zztG() {
        HashSet hashSet = new HashSet();
        for (String string : this.zzasQ.keySet()) {
            hashSet.add(zze.zzdc(string));
        }
        return hashSet;
    }

    public void setContext(Context context) {
        BitmapTeleporter bitmapTeleporter = this.zza(zznm.zzatz);
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzc(context.getCacheDir());
        }
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        for (String string : this.zzasQ.keySet()) {
            n2 = n2 * 31 + this.zzasQ.get(string).hashCode();
        }
        return n2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetadataBundle)) {
            return false;
        }
        MetadataBundle metadataBundle = (MetadataBundle)obj;
        Set set = this.zzasQ.keySet();
        if (!set.equals(metadataBundle.zzasQ.keySet())) {
            return false;
        }
        for (String string : set) {
            if (zzw.equal((Object)this.zzasQ.get(string), (Object)metadataBundle.zzasQ.get(string))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "MetadataBundle [values=" + this.zzasQ + "]";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzh.zza(this, dest, flags);
    }
}

