/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.text.TextUtils;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.internal.zzu;

public class ExecutionOptions {
    public static final int MAX_TRACKING_TAG_STRING_LENGTH = 65536;
    public static final int CONFLICT_STRATEGY_OVERWRITE_REMOTE = 0;
    public static final int CONFLICT_STRATEGY_KEEP_REMOTE = 1;
    private final String zzavv;
    private final boolean zzavw;
    private final int zzavx;

    public ExecutionOptions(String string, boolean bl, int n) {
        this.zzavv = string;
        this.zzavw = bl;
        this.zzavx = n;
    }

    public String zzvK() {
        return this.zzavv;
    }

    public boolean zzvL() {
        return this.zzavw;
    }

    public int zzvM() {
        return this.zzavx;
    }

    public static boolean zzcL(int n) {
        switch (n) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean zzcM(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean zzdx(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && string.length() <= 65536;
    }

    public void zzg(GoogleApiClient googleApiClient) {
        zzu zzu2 = (zzu)googleApiClient.zza(Drive.zzaaz);
        if (this.zzvL() && !zzu2.zzwr()) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to be notified on completion");
        }
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        if (object == this) {
            return true;
        }
        ExecutionOptions executionOptions = (ExecutionOptions)object;
        return zzz.equal((Object)this.zzavv, (Object)executionOptions.zzavv) && this.zzavx == executionOptions.zzavx && this.zzavw == executionOptions.zzavw;
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzavv, this.zzavx, this.zzavw});
    }

    public static class Builder {
        protected String zzavv;
        protected boolean zzavw;
        protected int zzavx = 0;

        public Builder setTrackingTag(String string) {
            if (!ExecutionOptions.zzdx(string)) {
                throw new IllegalArgumentException(String.format("trackingTag must not be null nor empty, and the length must be <= the maximum length (%s)", 65536));
            }
            this.zzavv = string;
            return this;
        }

        public Builder setNotifyOnCompletion(boolean bl) {
            this.zzavw = bl;
            return this;
        }

        public Builder setConflictStrategy(int n) {
            if (!ExecutionOptions.zzcM(n)) {
                throw new IllegalArgumentException(new StringBuilder(53).append("Unrecognized value for conflict strategy: ").append(n).toString());
            }
            this.zzavx = n;
            return this;
        }

        protected void zzvN() {
            if (this.zzavx == 1 && !this.zzavw) {
                throw new IllegalStateException("Cannot use CONFLICT_STRATEGY_KEEP_REMOTE without requesting completion notifications");
            }
        }

        public ExecutionOptions build() {
            this.zzvN();
            return new ExecutionOptions(this.zzavv, this.zzavw, this.zzavx);
        }
    }
}

